// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.resourcemanager.authorization.fluent.GroupLifecyclePoliciesGroupLifecyclePoliciesClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfGroupLifecyclePolicy;
import com.azure.resourcemanager.authorization.fluent.models.Get1ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.Get2ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.Get5ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.Get6ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.Get7ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphGroupLifecyclePolicyInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import java.util.List;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in
 * GroupLifecyclePoliciesGroupLifecyclePoliciesClient.
 */
public final class GroupLifecyclePoliciesGroupLifecyclePoliciesClientImpl
    implements GroupLifecyclePoliciesGroupLifecyclePoliciesClient {
    private final ClientLogger logger = new ClientLogger(GroupLifecyclePoliciesGroupLifecyclePoliciesClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final GroupLifecyclePoliciesGroupLifecyclePoliciesService service;

    /** The service client containing this operation class. */
    private final MicrosoftGraphClientImpl client;

    /**
     * Initializes an instance of GroupLifecyclePoliciesGroupLifecyclePoliciesClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    GroupLifecyclePoliciesGroupLifecyclePoliciesClientImpl(MicrosoftGraphClientImpl client) {
        this.service =
            RestProxy
                .create(
                    GroupLifecyclePoliciesGroupLifecyclePoliciesService.class,
                    client.getHttpPipeline(),
                    client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for MicrosoftGraphClientGroupLifecyclePoliciesGroupLifecyclePolicies to
     * be used by the proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "MicrosoftGraphClient")
    private interface GroupLifecyclePoliciesGroupLifecyclePoliciesService {
        @Headers({"Content-Type: application/json"})
        @Get("/groupLifecyclePolicies")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfGroupLifecyclePolicy>> listGroupLifecyclePolicy(
            @HostParam("$host") String endpoint,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groupLifecyclePolicies")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphGroupLifecyclePolicyInner>> createGroupLifecyclePolicy(
            @HostParam("$host") String endpoint,
            @BodyParam("application/json") MicrosoftGraphGroupLifecyclePolicyInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/groupLifecyclePolicies/{groupLifecyclePolicy-id}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphGroupLifecyclePolicyInner>> getGroupLifecyclePolicy(
            @HostParam("$host") String endpoint,
            @PathParam("groupLifecyclePolicy-id") String groupLifecyclePolicyId,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/groupLifecyclePolicies/{groupLifecyclePolicy-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updateGroupLifecyclePolicy(
            @HostParam("$host") String endpoint,
            @PathParam("groupLifecyclePolicy-id") String groupLifecyclePolicyId,
            @BodyParam("application/json") MicrosoftGraphGroupLifecyclePolicyInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/groupLifecyclePolicies/{groupLifecyclePolicy-id}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteGroupLifecyclePolicy(
            @HostParam("$host") String endpoint,
            @PathParam("groupLifecyclePolicy-id") String groupLifecyclePolicyId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfGroupLifecyclePolicy>> listMore(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);
    }

    /**
     * Get entities from groupLifecyclePolicies.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from groupLifecyclePolicies.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphGroupLifecyclePolicyInner>> listGroupLifecyclePolicySinglePageAsync(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<Get5ItemsItem> orderby,
        List<Get6ItemsItem> select,
        List<Get7ItemsItem> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listGroupLifecyclePolicy(
                            this.client.getEndpoint(),
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphGroupLifecyclePolicyInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get entities from groupLifecyclePolicies.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from groupLifecyclePolicies.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphGroupLifecyclePolicyInner>> listGroupLifecyclePolicySinglePageAsync(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<Get5ItemsItem> orderby,
        List<Get6ItemsItem> select,
        List<Get7ItemsItem> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listGroupLifecyclePolicy(
                this.client.getEndpoint(),
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get entities from groupLifecyclePolicies.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from groupLifecyclePolicies.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphGroupLifecyclePolicyInner> listGroupLifecyclePolicyAsync(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<Get5ItemsItem> orderby,
        List<Get6ItemsItem> select,
        List<Get7ItemsItem> expand) {
        return new PagedFlux<>(
            () -> listGroupLifecyclePolicySinglePageAsync(top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get entities from groupLifecyclePolicies.
     *
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from groupLifecyclePolicies.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphGroupLifecyclePolicyInner> listGroupLifecyclePolicyAsync() {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<Get5ItemsItem> orderby = null;
        final List<Get6ItemsItem> select = null;
        final List<Get7ItemsItem> expand = null;
        return new PagedFlux<>(
            () -> listGroupLifecyclePolicySinglePageAsync(top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get entities from groupLifecyclePolicies.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from groupLifecyclePolicies.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphGroupLifecyclePolicyInner> listGroupLifecyclePolicyAsync(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<Get5ItemsItem> orderby,
        List<Get6ItemsItem> select,
        List<Get7ItemsItem> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listGroupLifecyclePolicySinglePageAsync(
                    top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listMoreSinglePageAsync(nextLink, context));
    }

    /**
     * Get entities from groupLifecyclePolicies.
     *
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from groupLifecyclePolicies.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphGroupLifecyclePolicyInner> listGroupLifecyclePolicy() {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<Get5ItemsItem> orderby = null;
        final List<Get6ItemsItem> select = null;
        final List<Get7ItemsItem> expand = null;
        return new PagedIterable<>(
            listGroupLifecyclePolicyAsync(top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get entities from groupLifecyclePolicies.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entities from groupLifecyclePolicies.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphGroupLifecyclePolicyInner> listGroupLifecyclePolicy(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<Get5ItemsItem> orderby,
        List<Get6ItemsItem> select,
        List<Get7ItemsItem> expand,
        Context context) {
        return new PagedIterable<>(
            listGroupLifecyclePolicyAsync(top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Add new entity to groupLifecyclePolicies.
     *
     * @param body New entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return groupLifecyclePolicy.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphGroupLifecyclePolicyInner>> createGroupLifecyclePolicyWithResponseAsync(
        MicrosoftGraphGroupLifecyclePolicyInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.createGroupLifecyclePolicy(this.client.getEndpoint(), body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Add new entity to groupLifecyclePolicies.
     *
     * @param body New entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return groupLifecyclePolicy.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphGroupLifecyclePolicyInner>> createGroupLifecyclePolicyWithResponseAsync(
        MicrosoftGraphGroupLifecyclePolicyInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createGroupLifecyclePolicy(this.client.getEndpoint(), body, accept, context);
    }

    /**
     * Add new entity to groupLifecyclePolicies.
     *
     * @param body New entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return groupLifecyclePolicy.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphGroupLifecyclePolicyInner> createGroupLifecyclePolicyAsync(
        MicrosoftGraphGroupLifecyclePolicyInner body) {
        return createGroupLifecyclePolicyWithResponseAsync(body)
            .flatMap(
                (Response<MicrosoftGraphGroupLifecyclePolicyInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Add new entity to groupLifecyclePolicies.
     *
     * @param body New entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return groupLifecyclePolicy.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphGroupLifecyclePolicyInner createGroupLifecyclePolicy(
        MicrosoftGraphGroupLifecyclePolicyInner body) {
        return createGroupLifecyclePolicyAsync(body).block();
    }

    /**
     * Add new entity to groupLifecyclePolicies.
     *
     * @param body New entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return groupLifecyclePolicy.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphGroupLifecyclePolicyInner> createGroupLifecyclePolicyWithResponse(
        MicrosoftGraphGroupLifecyclePolicyInner body, Context context) {
        return createGroupLifecyclePolicyWithResponseAsync(body, context).block();
    }

    /**
     * Get entity from groupLifecyclePolicies by key.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from groupLifecyclePolicies by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphGroupLifecyclePolicyInner>> getGroupLifecyclePolicyWithResponseAsync(
        String groupLifecyclePolicyId, List<Get1ItemsItem> select, List<Get2ItemsItem> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupLifecyclePolicyId == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter groupLifecyclePolicyId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getGroupLifecyclePolicy(
                            this.client.getEndpoint(),
                            groupLifecyclePolicyId,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get entity from groupLifecyclePolicies by key.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from groupLifecyclePolicies by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphGroupLifecyclePolicyInner>> getGroupLifecyclePolicyWithResponseAsync(
        String groupLifecyclePolicyId, List<Get1ItemsItem> select, List<Get2ItemsItem> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupLifecyclePolicyId == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter groupLifecyclePolicyId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .getGroupLifecyclePolicy(
                this.client.getEndpoint(), groupLifecyclePolicyId, selectConverted, expandConverted, accept, context);
    }

    /**
     * Get entity from groupLifecyclePolicies by key.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from groupLifecyclePolicies by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphGroupLifecyclePolicyInner> getGroupLifecyclePolicyAsync(
        String groupLifecyclePolicyId, List<Get1ItemsItem> select, List<Get2ItemsItem> expand) {
        return getGroupLifecyclePolicyWithResponseAsync(groupLifecyclePolicyId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphGroupLifecyclePolicyInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get entity from groupLifecyclePolicies by key.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from groupLifecyclePolicies by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphGroupLifecyclePolicyInner> getGroupLifecyclePolicyAsync(String groupLifecyclePolicyId) {
        final List<Get1ItemsItem> select = null;
        final List<Get2ItemsItem> expand = null;
        return getGroupLifecyclePolicyWithResponseAsync(groupLifecyclePolicyId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphGroupLifecyclePolicyInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get entity from groupLifecyclePolicies by key.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from groupLifecyclePolicies by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphGroupLifecyclePolicyInner getGroupLifecyclePolicy(String groupLifecyclePolicyId) {
        final List<Get1ItemsItem> select = null;
        final List<Get2ItemsItem> expand = null;
        return getGroupLifecyclePolicyAsync(groupLifecyclePolicyId, select, expand).block();
    }

    /**
     * Get entity from groupLifecyclePolicies by key.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return entity from groupLifecyclePolicies by key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphGroupLifecyclePolicyInner> getGroupLifecyclePolicyWithResponse(
        String groupLifecyclePolicyId, List<Get1ItemsItem> select, List<Get2ItemsItem> expand, Context context) {
        return getGroupLifecyclePolicyWithResponseAsync(groupLifecyclePolicyId, select, expand, context).block();
    }

    /**
     * Update entity in groupLifecyclePolicies.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateGroupLifecyclePolicyWithResponseAsync(
        String groupLifecyclePolicyId, MicrosoftGraphGroupLifecyclePolicyInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupLifecyclePolicyId == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter groupLifecyclePolicyId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .updateGroupLifecyclePolicy(
                            this.client.getEndpoint(), groupLifecyclePolicyId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update entity in groupLifecyclePolicies.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param body New property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateGroupLifecyclePolicyWithResponseAsync(
        String groupLifecyclePolicyId, MicrosoftGraphGroupLifecyclePolicyInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupLifecyclePolicyId == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter groupLifecyclePolicyId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .updateGroupLifecyclePolicy(this.client.getEndpoint(), groupLifecyclePolicyId, body, accept, context);
    }

    /**
     * Update entity in groupLifecyclePolicies.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateGroupLifecyclePolicyAsync(
        String groupLifecyclePolicyId, MicrosoftGraphGroupLifecyclePolicyInner body) {
        return updateGroupLifecyclePolicyWithResponseAsync(groupLifecyclePolicyId, body)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update entity in groupLifecyclePolicies.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateGroupLifecyclePolicy(
        String groupLifecyclePolicyId, MicrosoftGraphGroupLifecyclePolicyInner body) {
        updateGroupLifecyclePolicyAsync(groupLifecyclePolicyId, body).block();
    }

    /**
     * Update entity in groupLifecyclePolicies.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param body New property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateGroupLifecyclePolicyWithResponse(
        String groupLifecyclePolicyId, MicrosoftGraphGroupLifecyclePolicyInner body, Context context) {
        return updateGroupLifecyclePolicyWithResponseAsync(groupLifecyclePolicyId, body, context).block();
    }

    /**
     * Delete entity from groupLifecyclePolicies.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteGroupLifecyclePolicyWithResponseAsync(
        String groupLifecyclePolicyId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupLifecyclePolicyId == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter groupLifecyclePolicyId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteGroupLifecyclePolicy(
                            this.client.getEndpoint(), groupLifecyclePolicyId, ifMatch, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete entity from groupLifecyclePolicies.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteGroupLifecyclePolicyWithResponseAsync(
        String groupLifecyclePolicyId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupLifecyclePolicyId == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter groupLifecyclePolicyId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .deleteGroupLifecyclePolicy(this.client.getEndpoint(), groupLifecyclePolicyId, ifMatch, accept, context);
    }

    /**
     * Delete entity from groupLifecyclePolicies.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteGroupLifecyclePolicyAsync(String groupLifecyclePolicyId, String ifMatch) {
        return deleteGroupLifecyclePolicyWithResponseAsync(groupLifecyclePolicyId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete entity from groupLifecyclePolicies.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteGroupLifecyclePolicyAsync(String groupLifecyclePolicyId) {
        final String ifMatch = null;
        return deleteGroupLifecyclePolicyWithResponseAsync(groupLifecyclePolicyId, ifMatch)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete entity from groupLifecyclePolicies.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteGroupLifecyclePolicy(String groupLifecyclePolicyId) {
        final String ifMatch = null;
        deleteGroupLifecyclePolicyAsync(groupLifecyclePolicyId, ifMatch).block();
    }

    /**
     * Delete entity from groupLifecyclePolicies.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteGroupLifecyclePolicyWithResponse(
        String groupLifecyclePolicyId, String ifMatch, Context context) {
        return deleteGroupLifecyclePolicyWithResponseAsync(groupLifecyclePolicyId, ifMatch, context).block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of groupLifecyclePolicy.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphGroupLifecyclePolicyInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listMore(nextLink, context))
            .<PagedResponse<MicrosoftGraphGroupLifecyclePolicyInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of groupLifecyclePolicy.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphGroupLifecyclePolicyInner>> listMoreSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listMore(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }
}
