// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.authorization.fluent.GroupLifecyclePoliciesClient;
import com.azure.resourcemanager.authorization.fluent.models.GroupLifecyclePoliciesAddGroupRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.GroupLifecyclePoliciesRemoveGroupRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in GroupLifecyclePoliciesClient. */
public final class GroupLifecyclePoliciesClientImpl implements GroupLifecyclePoliciesClient {
    private final ClientLogger logger = new ClientLogger(GroupLifecyclePoliciesClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final GroupLifecyclePoliciesService service;

    /** The service client containing this operation class. */
    private final MicrosoftGraphClientImpl client;

    /**
     * Initializes an instance of GroupLifecyclePoliciesClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    GroupLifecyclePoliciesClientImpl(MicrosoftGraphClientImpl client) {
        this.service =
            RestProxy
                .create(GroupLifecyclePoliciesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for MicrosoftGraphClientGroupLifecyclePolicies to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "MicrosoftGraphClient")
    private interface GroupLifecyclePoliciesService {
        @Headers({"Content-Type: application/json"})
        @Post("/groupLifecyclePolicies/{groupLifecyclePolicy-id}/microsoft.graph.addGroup")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Boolean>> addGroup(
            @HostParam("$host") String endpoint,
            @PathParam("groupLifecyclePolicy-id") String groupLifecyclePolicyId,
            @BodyParam("application/json") GroupLifecyclePoliciesAddGroupRequestBody body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/groupLifecyclePolicies/{groupLifecyclePolicy-id}/microsoft.graph.removeGroup")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Boolean>> removeGroup(
            @HostParam("$host") String endpoint,
            @PathParam("groupLifecyclePolicy-id") String groupLifecyclePolicyId,
            @BodyParam("application/json") GroupLifecyclePoliciesRemoveGroupRequestBody body,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Invoke action addGroup.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Boolean>> addGroupWithResponseAsync(
        String groupLifecyclePolicyId, GroupLifecyclePoliciesAddGroupRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupLifecyclePolicyId == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter groupLifecyclePolicyId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.addGroup(this.client.getEndpoint(), groupLifecyclePolicyId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action addGroup.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Boolean>> addGroupWithResponseAsync(
        String groupLifecyclePolicyId, GroupLifecyclePoliciesAddGroupRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupLifecyclePolicyId == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter groupLifecyclePolicyId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.addGroup(this.client.getEndpoint(), groupLifecyclePolicyId, body, accept, context);
    }

    /**
     * Invoke action addGroup.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Boolean> addGroupAsync(String groupLifecyclePolicyId, GroupLifecyclePoliciesAddGroupRequestBody body) {
        return addGroupWithResponseAsync(groupLifecyclePolicyId, body)
            .flatMap(
                (Response<Boolean> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Invoke action addGroup.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public boolean addGroup(String groupLifecyclePolicyId, GroupLifecyclePoliciesAddGroupRequestBody body) {
        Boolean value = addGroupAsync(groupLifecyclePolicyId, body).block();
        if (value != null) {
            return value;
        } else {
            throw logger.logExceptionAsError(new NullPointerException());
        }
    }

    /**
     * Invoke action addGroup.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Boolean> addGroupWithResponse(
        String groupLifecyclePolicyId, GroupLifecyclePoliciesAddGroupRequestBody body, Context context) {
        return addGroupWithResponseAsync(groupLifecyclePolicyId, body, context).block();
    }

    /**
     * Invoke action removeGroup.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Boolean>> removeGroupWithResponseAsync(
        String groupLifecyclePolicyId, GroupLifecyclePoliciesRemoveGroupRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupLifecyclePolicyId == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter groupLifecyclePolicyId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.removeGroup(this.client.getEndpoint(), groupLifecyclePolicyId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action removeGroup.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Boolean>> removeGroupWithResponseAsync(
        String groupLifecyclePolicyId, GroupLifecyclePoliciesRemoveGroupRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupLifecyclePolicyId == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter groupLifecyclePolicyId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.removeGroup(this.client.getEndpoint(), groupLifecyclePolicyId, body, accept, context);
    }

    /**
     * Invoke action removeGroup.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Boolean> removeGroupAsync(
        String groupLifecyclePolicyId, GroupLifecyclePoliciesRemoveGroupRequestBody body) {
        return removeGroupWithResponseAsync(groupLifecyclePolicyId, body)
            .flatMap(
                (Response<Boolean> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Invoke action removeGroup.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public boolean removeGroup(String groupLifecyclePolicyId, GroupLifecyclePoliciesRemoveGroupRequestBody body) {
        Boolean value = removeGroupAsync(groupLifecyclePolicyId, body).block();
        if (value != null) {
            return value;
        } else {
            throw logger.logExceptionAsError(new NullPointerException());
        }
    }

    /**
     * Invoke action removeGroup.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Boolean> removeGroupWithResponse(
        String groupLifecyclePolicyId, GroupLifecyclePoliciesRemoveGroupRequestBody body, Context context) {
        return removeGroupWithResponseAsync(groupLifecyclePolicyId, body, context).block();
    }
}
