// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.authorization.fluent.DenyAssignmentsClient;
import com.azure.resourcemanager.authorization.fluent.models.DenyAssignmentInner;
import com.azure.resourcemanager.authorization.models.DenyAssignmentListResult;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in DenyAssignmentsClient. */
public final class DenyAssignmentsClientImpl
    implements InnerSupportsListing<DenyAssignmentInner>, DenyAssignmentsClient {
    private final ClientLogger logger = new ClientLogger(DenyAssignmentsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final DenyAssignmentsService service;

    /** The service client containing this operation class. */
    private final AuthorizationManagementClientImpl client;

    /**
     * Initializes an instance of DenyAssignmentsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    DenyAssignmentsClientImpl(AuthorizationManagementClientImpl client) {
        this.service =
            RestProxy.create(DenyAssignmentsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AuthorizationManagementClientDenyAssignments to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "AuthorizationManagem")
    private interface DenyAssignmentsService {
        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}"
                + "/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization"
                + "/denyAssignments")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DenyAssignmentListResult>> listForResource(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam(value = "resourceProviderNamespace", encoded = true) String resourceProviderNamespace,
            @PathParam(value = "parentResourcePath", encoded = true) String parentResourcePath,
            @PathParam(value = "resourceType", encoded = true) String resourceType,
            @PathParam("resourceName") String resourceName,
            @QueryParam("api-version") String apiVersion,
            @QueryParam("$filter") String filter,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization"
                + "/denyAssignments")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DenyAssignmentListResult>> listByResourceGroup(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam("api-version") String apiVersion,
            @QueryParam("$filter") String filter,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/denyAssignments")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DenyAssignmentListResult>> list(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @QueryParam("$filter") String filter,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/{scope}/providers/Microsoft.Authorization/denyAssignments/{denyAssignmentId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DenyAssignmentInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("denyAssignmentId") String denyAssignmentId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/{denyAssignmentId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DenyAssignmentInner>> getById(
            @HostParam("$host") String endpoint,
            @PathParam(value = "denyAssignmentId", encoded = true) String denyAssignmentId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/{scope}/providers/Microsoft.Authorization/denyAssignments")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DenyAssignmentListResult>> listForScope(
            @HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @QueryParam("api-version") String apiVersion,
            @QueryParam("$filter") String filter,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DenyAssignmentListResult>> listForResourceNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DenyAssignmentListResult>> listForResourceGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DenyAssignmentListResult>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DenyAssignmentListResult>> listForScopeNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Gets deny assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get deny assignments for.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all deny assignments at or
     *     above the scope. Use $filter=denyAssignmentName eq '{name}' to search deny assignments by name at specified
     *     scope. Use $filter=principalId eq '{id}' to return all deny assignments at, above and below the scope for the
     *     specified principal. Use $filter=gdprExportPrincipalId eq '{id}' to return all deny assignments at, above and
     *     below the scope for the specified principal. This filter is different from the principalId filter as it
     *     returns not only those deny assignments that contain the specified principal is the Principals list but also
     *     those deny assignments that contain the specified principal is the ExcludePrincipals list. Additionally, when
     *     gdprExportPrincipalId filter is used, only the deny assignment name and description properties are returned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignments for a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DenyAssignmentInner>> listForResourceSinglePageAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        final String apiVersion = "2018-07-01-preview";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listForResource(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            resourceProviderNamespace,
                            parentResourcePath,
                            resourceType,
                            resourceName,
                            apiVersion,
                            filter,
                            accept,
                            context))
            .<PagedResponse<DenyAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets deny assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get deny assignments for.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all deny assignments at or
     *     above the scope. Use $filter=denyAssignmentName eq '{name}' to search deny assignments by name at specified
     *     scope. Use $filter=principalId eq '{id}' to return all deny assignments at, above and below the scope for the
     *     specified principal. Use $filter=gdprExportPrincipalId eq '{id}' to return all deny assignments at, above and
     *     below the scope for the specified principal. This filter is different from the principalId filter as it
     *     returns not only those deny assignments that contain the specified principal is the Principals list but also
     *     those deny assignments that contain the specified principal is the ExcludePrincipals list. Additionally, when
     *     gdprExportPrincipalId filter is used, only the deny assignment name and description properties are returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignments for a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DenyAssignmentInner>> listForResourceSinglePageAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String filter,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        final String apiVersion = "2018-07-01-preview";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listForResource(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                apiVersion,
                filter,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Gets deny assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get deny assignments for.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all deny assignments at or
     *     above the scope. Use $filter=denyAssignmentName eq '{name}' to search deny assignments by name at specified
     *     scope. Use $filter=principalId eq '{id}' to return all deny assignments at, above and below the scope for the
     *     specified principal. Use $filter=gdprExportPrincipalId eq '{id}' to return all deny assignments at, above and
     *     below the scope for the specified principal. This filter is different from the principalId filter as it
     *     returns not only those deny assignments that contain the specified principal is the Principals list but also
     *     those deny assignments that contain the specified principal is the ExcludePrincipals list. Additionally, when
     *     gdprExportPrincipalId filter is used, only the deny assignment name and description properties are returned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignments for a resource.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DenyAssignmentInner> listForResourceAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String filter) {
        return new PagedFlux<>(
            () ->
                listForResourceSinglePageAsync(
                    resourceGroupName,
                    resourceProviderNamespace,
                    parentResourcePath,
                    resourceType,
                    resourceName,
                    filter),
            nextLink -> listForResourceNextSinglePageAsync(nextLink));
    }

    /**
     * Gets deny assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get deny assignments for.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignments for a resource.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DenyAssignmentInner> listForResourceAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName) {
        final String filter = null;
        return new PagedFlux<>(
            () ->
                listForResourceSinglePageAsync(
                    resourceGroupName,
                    resourceProviderNamespace,
                    parentResourcePath,
                    resourceType,
                    resourceName,
                    filter),
            nextLink -> listForResourceNextSinglePageAsync(nextLink));
    }

    /**
     * Gets deny assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get deny assignments for.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all deny assignments at or
     *     above the scope. Use $filter=denyAssignmentName eq '{name}' to search deny assignments by name at specified
     *     scope. Use $filter=principalId eq '{id}' to return all deny assignments at, above and below the scope for the
     *     specified principal. Use $filter=gdprExportPrincipalId eq '{id}' to return all deny assignments at, above and
     *     below the scope for the specified principal. This filter is different from the principalId filter as it
     *     returns not only those deny assignments that contain the specified principal is the Principals list but also
     *     those deny assignments that contain the specified principal is the ExcludePrincipals list. Additionally, when
     *     gdprExportPrincipalId filter is used, only the deny assignment name and description properties are returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignments for a resource.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DenyAssignmentInner> listForResourceAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String filter,
        Context context) {
        return new PagedFlux<>(
            () ->
                listForResourceSinglePageAsync(
                    resourceGroupName,
                    resourceProviderNamespace,
                    parentResourcePath,
                    resourceType,
                    resourceName,
                    filter,
                    context),
            nextLink -> listForResourceNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets deny assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get deny assignments for.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignments for a resource.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DenyAssignmentInner> listForResource(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName) {
        final String filter = null;
        return new PagedIterable<>(
            listForResourceAsync(
                resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter));
    }

    /**
     * Gets deny assignments for a resource.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource.
     * @param resourceName The name of the resource to get deny assignments for.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all deny assignments at or
     *     above the scope. Use $filter=denyAssignmentName eq '{name}' to search deny assignments by name at specified
     *     scope. Use $filter=principalId eq '{id}' to return all deny assignments at, above and below the scope for the
     *     specified principal. Use $filter=gdprExportPrincipalId eq '{id}' to return all deny assignments at, above and
     *     below the scope for the specified principal. This filter is different from the principalId filter as it
     *     returns not only those deny assignments that contain the specified principal is the Principals list but also
     *     those deny assignments that contain the specified principal is the ExcludePrincipals list. Additionally, when
     *     gdprExportPrincipalId filter is used, only the deny assignment name and description properties are returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignments for a resource.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DenyAssignmentInner> listForResource(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String filter,
        Context context) {
        return new PagedIterable<>(
            listForResourceAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                filter,
                context));
    }

    /**
     * Gets deny assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all deny assignments at or
     *     above the scope. Use $filter=denyAssignmentName eq '{name}' to search deny assignments by name at specified
     *     scope. Use $filter=principalId eq '{id}' to return all deny assignments at, above and below the scope for the
     *     specified principal. Use $filter=gdprExportPrincipalId eq '{id}' to return all deny assignments at, above and
     *     below the scope for the specified principal. This filter is different from the principalId filter as it
     *     returns not only those deny assignments that contain the specified principal is the Principals list but also
     *     those deny assignments that contain the specified principal is the ExcludePrincipals list. Additionally, when
     *     gdprExportPrincipalId filter is used, only the deny assignment name and description properties are returned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignments for a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DenyAssignmentInner>> listByResourceGroupSinglePageAsync(
        String resourceGroupName, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        final String apiVersion = "2018-07-01-preview";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByResourceGroup(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            apiVersion,
                            filter,
                            accept,
                            context))
            .<PagedResponse<DenyAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets deny assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all deny assignments at or
     *     above the scope. Use $filter=denyAssignmentName eq '{name}' to search deny assignments by name at specified
     *     scope. Use $filter=principalId eq '{id}' to return all deny assignments at, above and below the scope for the
     *     specified principal. Use $filter=gdprExportPrincipalId eq '{id}' to return all deny assignments at, above and
     *     below the scope for the specified principal. This filter is different from the principalId filter as it
     *     returns not only those deny assignments that contain the specified principal is the Principals list but also
     *     those deny assignments that contain the specified principal is the ExcludePrincipals list. Additionally, when
     *     gdprExportPrincipalId filter is used, only the deny assignment name and description properties are returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignments for a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DenyAssignmentInner>> listByResourceGroupSinglePageAsync(
        String resourceGroupName, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        final String apiVersion = "2018-07-01-preview";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroup(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                apiVersion,
                filter,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Gets deny assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all deny assignments at or
     *     above the scope. Use $filter=denyAssignmentName eq '{name}' to search deny assignments by name at specified
     *     scope. Use $filter=principalId eq '{id}' to return all deny assignments at, above and below the scope for the
     *     specified principal. Use $filter=gdprExportPrincipalId eq '{id}' to return all deny assignments at, above and
     *     below the scope for the specified principal. This filter is different from the principalId filter as it
     *     returns not only those deny assignments that contain the specified principal is the Principals list but also
     *     those deny assignments that contain the specified principal is the ExcludePrincipals list. Additionally, when
     *     gdprExportPrincipalId filter is used, only the deny assignment name and description properties are returned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignments for a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DenyAssignmentInner> listByResourceGroupAsync(String resourceGroupName, String filter) {
        return new PagedFlux<>(
            () -> listByResourceGroupSinglePageAsync(resourceGroupName, filter),
            nextLink -> listForResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Gets deny assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignments for a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DenyAssignmentInner> listByResourceGroupAsync(String resourceGroupName) {
        final String filter = null;
        return new PagedFlux<>(
            () -> listByResourceGroupSinglePageAsync(resourceGroupName, filter),
            nextLink -> listForResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Gets deny assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all deny assignments at or
     *     above the scope. Use $filter=denyAssignmentName eq '{name}' to search deny assignments by name at specified
     *     scope. Use $filter=principalId eq '{id}' to return all deny assignments at, above and below the scope for the
     *     specified principal. Use $filter=gdprExportPrincipalId eq '{id}' to return all deny assignments at, above and
     *     below the scope for the specified principal. This filter is different from the principalId filter as it
     *     returns not only those deny assignments that contain the specified principal is the Principals list but also
     *     those deny assignments that contain the specified principal is the ExcludePrincipals list. Additionally, when
     *     gdprExportPrincipalId filter is used, only the deny assignment name and description properties are returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignments for a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DenyAssignmentInner> listByResourceGroupAsync(
        String resourceGroupName, String filter, Context context) {
        return new PagedFlux<>(
            () -> listByResourceGroupSinglePageAsync(resourceGroupName, filter, context),
            nextLink -> listForResourceGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets deny assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignments for a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DenyAssignmentInner> listByResourceGroup(String resourceGroupName) {
        final String filter = null;
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, filter));
    }

    /**
     * Gets deny assignments for a resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all deny assignments at or
     *     above the scope. Use $filter=denyAssignmentName eq '{name}' to search deny assignments by name at specified
     *     scope. Use $filter=principalId eq '{id}' to return all deny assignments at, above and below the scope for the
     *     specified principal. Use $filter=gdprExportPrincipalId eq '{id}' to return all deny assignments at, above and
     *     below the scope for the specified principal. This filter is different from the principalId filter as it
     *     returns not only those deny assignments that contain the specified principal is the Principals list but also
     *     those deny assignments that contain the specified principal is the ExcludePrincipals list. Additionally, when
     *     gdprExportPrincipalId filter is used, only the deny assignment name and description properties are returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignments for a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DenyAssignmentInner> listByResourceGroup(
        String resourceGroupName, String filter, Context context) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, filter, context));
    }

    /**
     * Gets all deny assignments for the subscription.
     *
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all deny assignments at or
     *     above the scope. Use $filter=denyAssignmentName eq '{name}' to search deny assignments by name at specified
     *     scope. Use $filter=principalId eq '{id}' to return all deny assignments at, above and below the scope for the
     *     specified principal. Use $filter=gdprExportPrincipalId eq '{id}' to return all deny assignments at, above and
     *     below the scope for the specified principal. This filter is different from the principalId filter as it
     *     returns not only those deny assignments that contain the specified principal is the Principals list but also
     *     those deny assignments that contain the specified principal is the ExcludePrincipals list. Additionally, when
     *     gdprExportPrincipalId filter is used, only the deny assignment name and description properties are returned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all deny assignments for the subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DenyAssignmentInner>> listSinglePageAsync(String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2018-07-01-preview";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            apiVersion,
                            filter,
                            accept,
                            context))
            .<PagedResponse<DenyAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets all deny assignments for the subscription.
     *
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all deny assignments at or
     *     above the scope. Use $filter=denyAssignmentName eq '{name}' to search deny assignments by name at specified
     *     scope. Use $filter=principalId eq '{id}' to return all deny assignments at, above and below the scope for the
     *     specified principal. Use $filter=gdprExportPrincipalId eq '{id}' to return all deny assignments at, above and
     *     below the scope for the specified principal. This filter is different from the principalId filter as it
     *     returns not only those deny assignments that contain the specified principal is the Principals list but also
     *     those deny assignments that contain the specified principal is the ExcludePrincipals list. Additionally, when
     *     gdprExportPrincipalId filter is used, only the deny assignment name and description properties are returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all deny assignments for the subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DenyAssignmentInner>> listSinglePageAsync(String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2018-07-01-preview";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getSubscriptionId(), apiVersion, filter, accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Gets all deny assignments for the subscription.
     *
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all deny assignments at or
     *     above the scope. Use $filter=denyAssignmentName eq '{name}' to search deny assignments by name at specified
     *     scope. Use $filter=principalId eq '{id}' to return all deny assignments at, above and below the scope for the
     *     specified principal. Use $filter=gdprExportPrincipalId eq '{id}' to return all deny assignments at, above and
     *     below the scope for the specified principal. This filter is different from the principalId filter as it
     *     returns not only those deny assignments that contain the specified principal is the Principals list but also
     *     those deny assignments that contain the specified principal is the ExcludePrincipals list. Additionally, when
     *     gdprExportPrincipalId filter is used, only the deny assignment name and description properties are returned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all deny assignments for the subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DenyAssignmentInner> listAsync(String filter) {
        return new PagedFlux<>(() -> listSinglePageAsync(filter), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Gets all deny assignments for the subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all deny assignments for the subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DenyAssignmentInner> listAsync() {
        final String filter = null;
        return new PagedFlux<>(() -> listSinglePageAsync(filter), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Gets all deny assignments for the subscription.
     *
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all deny assignments at or
     *     above the scope. Use $filter=denyAssignmentName eq '{name}' to search deny assignments by name at specified
     *     scope. Use $filter=principalId eq '{id}' to return all deny assignments at, above and below the scope for the
     *     specified principal. Use $filter=gdprExportPrincipalId eq '{id}' to return all deny assignments at, above and
     *     below the scope for the specified principal. This filter is different from the principalId filter as it
     *     returns not only those deny assignments that contain the specified principal is the Principals list but also
     *     those deny assignments that contain the specified principal is the ExcludePrincipals list. Additionally, when
     *     gdprExportPrincipalId filter is used, only the deny assignment name and description properties are returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all deny assignments for the subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DenyAssignmentInner> listAsync(String filter, Context context) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(filter, context), nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets all deny assignments for the subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all deny assignments for the subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DenyAssignmentInner> list() {
        final String filter = null;
        return new PagedIterable<>(listAsync(filter));
    }

    /**
     * Gets all deny assignments for the subscription.
     *
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all deny assignments at or
     *     above the scope. Use $filter=denyAssignmentName eq '{name}' to search deny assignments by name at specified
     *     scope. Use $filter=principalId eq '{id}' to return all deny assignments at, above and below the scope for the
     *     specified principal. Use $filter=gdprExportPrincipalId eq '{id}' to return all deny assignments at, above and
     *     below the scope for the specified principal. This filter is different from the principalId filter as it
     *     returns not only those deny assignments that contain the specified principal is the Principals list but also
     *     those deny assignments that contain the specified principal is the ExcludePrincipals list. Additionally, when
     *     gdprExportPrincipalId filter is used, only the deny assignment name and description properties are returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all deny assignments for the subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DenyAssignmentInner> list(String filter, Context context) {
        return new PagedIterable<>(listAsync(filter, context));
    }

    /**
     * Get the specified deny assignment.
     *
     * @param scope The scope of the deny assignment.
     * @param denyAssignmentId The ID of the deny assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified deny assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DenyAssignmentInner>> getWithResponseAsync(String scope, String denyAssignmentId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (denyAssignmentId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter denyAssignmentId is required and cannot be null."));
        }
        final String apiVersion = "2018-07-01-preview";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.get(this.client.getEndpoint(), scope, denyAssignmentId, apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the specified deny assignment.
     *
     * @param scope The scope of the deny assignment.
     * @param denyAssignmentId The ID of the deny assignment to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified deny assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DenyAssignmentInner>> getWithResponseAsync(
        String scope, String denyAssignmentId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (denyAssignmentId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter denyAssignmentId is required and cannot be null."));
        }
        final String apiVersion = "2018-07-01-preview";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), scope, denyAssignmentId, apiVersion, accept, context);
    }

    /**
     * Get the specified deny assignment.
     *
     * @param scope The scope of the deny assignment.
     * @param denyAssignmentId The ID of the deny assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified deny assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DenyAssignmentInner> getAsync(String scope, String denyAssignmentId) {
        return getWithResponseAsync(scope, denyAssignmentId)
            .flatMap(
                (Response<DenyAssignmentInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get the specified deny assignment.
     *
     * @param scope The scope of the deny assignment.
     * @param denyAssignmentId The ID of the deny assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified deny assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DenyAssignmentInner get(String scope, String denyAssignmentId) {
        return getAsync(scope, denyAssignmentId).block();
    }

    /**
     * Get the specified deny assignment.
     *
     * @param scope The scope of the deny assignment.
     * @param denyAssignmentId The ID of the deny assignment to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified deny assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DenyAssignmentInner> getWithResponse(String scope, String denyAssignmentId, Context context) {
        return getWithResponseAsync(scope, denyAssignmentId, context).block();
    }

    /**
     * Gets a deny assignment by ID.
     *
     * @param denyAssignmentId The fully qualified deny assignment ID. For example, use the format,
     *     /subscriptions/{guid}/providers/Microsoft.Authorization/denyAssignments/{denyAssignmentId} for subscription
     *     level deny assignments, or /providers/Microsoft.Authorization/denyAssignments/{denyAssignmentId} for tenant
     *     level deny assignments.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deny assignment by ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DenyAssignmentInner>> getByIdWithResponseAsync(String denyAssignmentId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (denyAssignmentId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter denyAssignmentId is required and cannot be null."));
        }
        final String apiVersion = "2018-07-01-preview";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getById(this.client.getEndpoint(), denyAssignmentId, apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a deny assignment by ID.
     *
     * @param denyAssignmentId The fully qualified deny assignment ID. For example, use the format,
     *     /subscriptions/{guid}/providers/Microsoft.Authorization/denyAssignments/{denyAssignmentId} for subscription
     *     level deny assignments, or /providers/Microsoft.Authorization/denyAssignments/{denyAssignmentId} for tenant
     *     level deny assignments.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deny assignment by ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DenyAssignmentInner>> getByIdWithResponseAsync(String denyAssignmentId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (denyAssignmentId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter denyAssignmentId is required and cannot be null."));
        }
        final String apiVersion = "2018-07-01-preview";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getById(this.client.getEndpoint(), denyAssignmentId, apiVersion, accept, context);
    }

    /**
     * Gets a deny assignment by ID.
     *
     * @param denyAssignmentId The fully qualified deny assignment ID. For example, use the format,
     *     /subscriptions/{guid}/providers/Microsoft.Authorization/denyAssignments/{denyAssignmentId} for subscription
     *     level deny assignments, or /providers/Microsoft.Authorization/denyAssignments/{denyAssignmentId} for tenant
     *     level deny assignments.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deny assignment by ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DenyAssignmentInner> getByIdAsync(String denyAssignmentId) {
        return getByIdWithResponseAsync(denyAssignmentId)
            .flatMap(
                (Response<DenyAssignmentInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets a deny assignment by ID.
     *
     * @param denyAssignmentId The fully qualified deny assignment ID. For example, use the format,
     *     /subscriptions/{guid}/providers/Microsoft.Authorization/denyAssignments/{denyAssignmentId} for subscription
     *     level deny assignments, or /providers/Microsoft.Authorization/denyAssignments/{denyAssignmentId} for tenant
     *     level deny assignments.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deny assignment by ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DenyAssignmentInner getById(String denyAssignmentId) {
        return getByIdAsync(denyAssignmentId).block();
    }

    /**
     * Gets a deny assignment by ID.
     *
     * @param denyAssignmentId The fully qualified deny assignment ID. For example, use the format,
     *     /subscriptions/{guid}/providers/Microsoft.Authorization/denyAssignments/{denyAssignmentId} for subscription
     *     level deny assignments, or /providers/Microsoft.Authorization/denyAssignments/{denyAssignmentId} for tenant
     *     level deny assignments.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deny assignment by ID.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DenyAssignmentInner> getByIdWithResponse(String denyAssignmentId, Context context) {
        return getByIdWithResponseAsync(denyAssignmentId, context).block();
    }

    /**
     * Gets deny assignments for a scope.
     *
     * @param scope The scope of the deny assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all deny assignments at or
     *     above the scope. Use $filter=denyAssignmentName eq '{name}' to search deny assignments by name at specified
     *     scope. Use $filter=principalId eq '{id}' to return all deny assignments at, above and below the scope for the
     *     specified principal. Use $filter=gdprExportPrincipalId eq '{id}' to return all deny assignments at, above and
     *     below the scope for the specified principal. This filter is different from the principalId filter as it
     *     returns not only those deny assignments that contain the specified principal is the Principals list but also
     *     those deny assignments that contain the specified principal is the ExcludePrincipals list. Additionally, when
     *     gdprExportPrincipalId filter is used, only the deny assignment name and description properties are returned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignments for a scope.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DenyAssignmentInner>> listForScopeSinglePageAsync(String scope, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        final String apiVersion = "2018-07-01-preview";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listForScope(this.client.getEndpoint(), scope, apiVersion, filter, accept, context))
            .<PagedResponse<DenyAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets deny assignments for a scope.
     *
     * @param scope The scope of the deny assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all deny assignments at or
     *     above the scope. Use $filter=denyAssignmentName eq '{name}' to search deny assignments by name at specified
     *     scope. Use $filter=principalId eq '{id}' to return all deny assignments at, above and below the scope for the
     *     specified principal. Use $filter=gdprExportPrincipalId eq '{id}' to return all deny assignments at, above and
     *     below the scope for the specified principal. This filter is different from the principalId filter as it
     *     returns not only those deny assignments that contain the specified principal is the Principals list but also
     *     those deny assignments that contain the specified principal is the ExcludePrincipals list. Additionally, when
     *     gdprExportPrincipalId filter is used, only the deny assignment name and description properties are returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignments for a scope.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DenyAssignmentInner>> listForScopeSinglePageAsync(
        String scope, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        final String apiVersion = "2018-07-01-preview";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listForScope(this.client.getEndpoint(), scope, apiVersion, filter, accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Gets deny assignments for a scope.
     *
     * @param scope The scope of the deny assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all deny assignments at or
     *     above the scope. Use $filter=denyAssignmentName eq '{name}' to search deny assignments by name at specified
     *     scope. Use $filter=principalId eq '{id}' to return all deny assignments at, above and below the scope for the
     *     specified principal. Use $filter=gdprExportPrincipalId eq '{id}' to return all deny assignments at, above and
     *     below the scope for the specified principal. This filter is different from the principalId filter as it
     *     returns not only those deny assignments that contain the specified principal is the Principals list but also
     *     those deny assignments that contain the specified principal is the ExcludePrincipals list. Additionally, when
     *     gdprExportPrincipalId filter is used, only the deny assignment name and description properties are returned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignments for a scope.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DenyAssignmentInner> listForScopeAsync(String scope, String filter) {
        return new PagedFlux<>(
            () -> listForScopeSinglePageAsync(scope, filter), nextLink -> listForScopeNextSinglePageAsync(nextLink));
    }

    /**
     * Gets deny assignments for a scope.
     *
     * @param scope The scope of the deny assignments.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignments for a scope.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DenyAssignmentInner> listForScopeAsync(String scope) {
        final String filter = null;
        return new PagedFlux<>(
            () -> listForScopeSinglePageAsync(scope, filter), nextLink -> listForScopeNextSinglePageAsync(nextLink));
    }

    /**
     * Gets deny assignments for a scope.
     *
     * @param scope The scope of the deny assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all deny assignments at or
     *     above the scope. Use $filter=denyAssignmentName eq '{name}' to search deny assignments by name at specified
     *     scope. Use $filter=principalId eq '{id}' to return all deny assignments at, above and below the scope for the
     *     specified principal. Use $filter=gdprExportPrincipalId eq '{id}' to return all deny assignments at, above and
     *     below the scope for the specified principal. This filter is different from the principalId filter as it
     *     returns not only those deny assignments that contain the specified principal is the Principals list but also
     *     those deny assignments that contain the specified principal is the ExcludePrincipals list. Additionally, when
     *     gdprExportPrincipalId filter is used, only the deny assignment name and description properties are returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignments for a scope.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DenyAssignmentInner> listForScopeAsync(String scope, String filter, Context context) {
        return new PagedFlux<>(
            () -> listForScopeSinglePageAsync(scope, filter, context),
            nextLink -> listForScopeNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets deny assignments for a scope.
     *
     * @param scope The scope of the deny assignments.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignments for a scope.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DenyAssignmentInner> listForScope(String scope) {
        final String filter = null;
        return new PagedIterable<>(listForScopeAsync(scope, filter));
    }

    /**
     * Gets deny assignments for a scope.
     *
     * @param scope The scope of the deny assignments.
     * @param filter The filter to apply on the operation. Use $filter=atScope() to return all deny assignments at or
     *     above the scope. Use $filter=denyAssignmentName eq '{name}' to search deny assignments by name at specified
     *     scope. Use $filter=principalId eq '{id}' to return all deny assignments at, above and below the scope for the
     *     specified principal. Use $filter=gdprExportPrincipalId eq '{id}' to return all deny assignments at, above and
     *     below the scope for the specified principal. This filter is different from the principalId filter as it
     *     returns not only those deny assignments that contain the specified principal is the Principals list but also
     *     those deny assignments that contain the specified principal is the ExcludePrincipals list. Additionally, when
     *     gdprExportPrincipalId filter is used, only the deny assignment name and description properties are returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignments for a scope.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DenyAssignmentInner> listForScope(String scope, String filter, Context context) {
        return new PagedIterable<>(listForScopeAsync(scope, filter, context));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignment list operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DenyAssignmentInner>> listForResourceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listForResourceNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DenyAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignment list operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DenyAssignmentInner>> listForResourceNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listForResourceNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignment list operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DenyAssignmentInner>> listForResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listForResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DenyAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignment list operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DenyAssignmentInner>> listForResourceGroupNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listForResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignment list operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DenyAssignmentInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DenyAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignment list operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DenyAssignmentInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignment list operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DenyAssignmentInner>> listForScopeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listForScopeNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DenyAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deny assignment list operation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DenyAssignmentInner>> listForScopeNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listForScopeNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
