// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Role Assignment Metrics. */
@Immutable
public final class RoleAssignmentMetricsResultInner {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(RoleAssignmentMetricsResultInner.class);

    /*
     * The subscription ID.
     */
    @JsonProperty(value = "subscriptionId", access = JsonProperty.Access.WRITE_ONLY)
    private String subscriptionId;

    /*
     * The role assignment limit.
     */
    @JsonProperty(value = "roleAssignmentsLimit", access = JsonProperty.Access.WRITE_ONLY)
    private Long roleAssignmentsLimit;

    /*
     * The number of current role assignments.
     */
    @JsonProperty(value = "roleAssignmentsCurrentCount", access = JsonProperty.Access.WRITE_ONLY)
    private Long roleAssignmentsCurrentCount;

    /*
     * The number of remaining role assignments available.
     */
    @JsonProperty(value = "roleAssignmentsRemainingCount", access = JsonProperty.Access.WRITE_ONLY)
    private Long roleAssignmentsRemainingCount;

    /**
     * Get the subscriptionId property: The subscription ID.
     *
     * @return the subscriptionId value.
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Get the roleAssignmentsLimit property: The role assignment limit.
     *
     * @return the roleAssignmentsLimit value.
     */
    public Long roleAssignmentsLimit() {
        return this.roleAssignmentsLimit;
    }

    /**
     * Get the roleAssignmentsCurrentCount property: The number of current role assignments.
     *
     * @return the roleAssignmentsCurrentCount value.
     */
    public Long roleAssignmentsCurrentCount() {
        return this.roleAssignmentsCurrentCount;
    }

    /**
     * Get the roleAssignmentsRemainingCount property: The number of remaining role assignments available.
     *
     * @return the roleAssignmentsRemainingCount value.
     */
    public Long roleAssignmentsRemainingCount() {
        return this.roleAssignmentsRemainingCount;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
