// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** workbookChartAxisTitle. */
@Fluent
public final class MicrosoftGraphWorkbookChartAxisTitle extends MicrosoftGraphEntity {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphWorkbookChartAxisTitle.class);

    /*
     * Represents the axis title.
     */
    @JsonProperty(value = "text")
    private String text;

    /*
     * A boolean that specifies the visibility of an axis title.
     */
    @JsonProperty(value = "visible")
    private Boolean visible;

    /*
     * workbookChartAxisTitleFormat
     */
    @JsonProperty(value = "format")
    private MicrosoftGraphWorkbookChartAxisTitleFormat format;

    /*
     * workbookChartAxisTitle
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the text property: Represents the axis title.
     *
     * @return the text value.
     */
    public String text() {
        return this.text;
    }

    /**
     * Set the text property: Represents the axis title.
     *
     * @param text the text value to set.
     * @return the MicrosoftGraphWorkbookChartAxisTitle object itself.
     */
    public MicrosoftGraphWorkbookChartAxisTitle withText(String text) {
        this.text = text;
        return this;
    }

    /**
     * Get the visible property: A boolean that specifies the visibility of an axis title.
     *
     * @return the visible value.
     */
    public Boolean visible() {
        return this.visible;
    }

    /**
     * Set the visible property: A boolean that specifies the visibility of an axis title.
     *
     * @param visible the visible value to set.
     * @return the MicrosoftGraphWorkbookChartAxisTitle object itself.
     */
    public MicrosoftGraphWorkbookChartAxisTitle withVisible(Boolean visible) {
        this.visible = visible;
        return this;
    }

    /**
     * Get the format property: workbookChartAxisTitleFormat.
     *
     * @return the format value.
     */
    public MicrosoftGraphWorkbookChartAxisTitleFormat format() {
        return this.format;
    }

    /**
     * Set the format property: workbookChartAxisTitleFormat.
     *
     * @param format the format value to set.
     * @return the MicrosoftGraphWorkbookChartAxisTitle object itself.
     */
    public MicrosoftGraphWorkbookChartAxisTitle withFormat(MicrosoftGraphWorkbookChartAxisTitleFormat format) {
        this.format = format;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookChartAxisTitle.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookChartAxisTitle.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookChartAxisTitle object itself.
     */
    public MicrosoftGraphWorkbookChartAxisTitle withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphWorkbookChartAxisTitle withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (format() != null) {
            format().validate();
        }
    }
}
