// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** userSettings. */
@Fluent
public final class MicrosoftGraphUserSettingsInner extends MicrosoftGraphEntity {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphUserSettingsInner.class);

    /*
     * The contributionToContentDiscoveryAsOrganizationDisabled property.
     */
    @JsonProperty(value = "contributionToContentDiscoveryAsOrganizationDisabled")
    private Boolean contributionToContentDiscoveryAsOrganizationDisabled;

    /*
     * The contributionToContentDiscoveryDisabled property.
     */
    @JsonProperty(value = "contributionToContentDiscoveryDisabled")
    private Boolean contributionToContentDiscoveryDisabled;

    /*
     * shiftPreferences
     */
    @JsonProperty(value = "shiftPreferences")
    private MicrosoftGraphShiftPreferencesInner shiftPreferences;

    /*
     * userSettings
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the contributionToContentDiscoveryAsOrganizationDisabled property: The
     * contributionToContentDiscoveryAsOrganizationDisabled property.
     *
     * @return the contributionToContentDiscoveryAsOrganizationDisabled value.
     */
    public Boolean contributionToContentDiscoveryAsOrganizationDisabled() {
        return this.contributionToContentDiscoveryAsOrganizationDisabled;
    }

    /**
     * Set the contributionToContentDiscoveryAsOrganizationDisabled property: The
     * contributionToContentDiscoveryAsOrganizationDisabled property.
     *
     * @param contributionToContentDiscoveryAsOrganizationDisabled the
     *     contributionToContentDiscoveryAsOrganizationDisabled value to set.
     * @return the MicrosoftGraphUserSettingsInner object itself.
     */
    public MicrosoftGraphUserSettingsInner withContributionToContentDiscoveryAsOrganizationDisabled(
        Boolean contributionToContentDiscoveryAsOrganizationDisabled) {
        this.contributionToContentDiscoveryAsOrganizationDisabled =
            contributionToContentDiscoveryAsOrganizationDisabled;
        return this;
    }

    /**
     * Get the contributionToContentDiscoveryDisabled property: The contributionToContentDiscoveryDisabled property.
     *
     * @return the contributionToContentDiscoveryDisabled value.
     */
    public Boolean contributionToContentDiscoveryDisabled() {
        return this.contributionToContentDiscoveryDisabled;
    }

    /**
     * Set the contributionToContentDiscoveryDisabled property: The contributionToContentDiscoveryDisabled property.
     *
     * @param contributionToContentDiscoveryDisabled the contributionToContentDiscoveryDisabled value to set.
     * @return the MicrosoftGraphUserSettingsInner object itself.
     */
    public MicrosoftGraphUserSettingsInner withContributionToContentDiscoveryDisabled(
        Boolean contributionToContentDiscoveryDisabled) {
        this.contributionToContentDiscoveryDisabled = contributionToContentDiscoveryDisabled;
        return this;
    }

    /**
     * Get the shiftPreferences property: shiftPreferences.
     *
     * @return the shiftPreferences value.
     */
    public MicrosoftGraphShiftPreferencesInner shiftPreferences() {
        return this.shiftPreferences;
    }

    /**
     * Set the shiftPreferences property: shiftPreferences.
     *
     * @param shiftPreferences the shiftPreferences value to set.
     * @return the MicrosoftGraphUserSettingsInner object itself.
     */
    public MicrosoftGraphUserSettingsInner withShiftPreferences(MicrosoftGraphShiftPreferencesInner shiftPreferences) {
        this.shiftPreferences = shiftPreferences;
        return this;
    }

    /**
     * Get the additionalProperties property: userSettings.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: userSettings.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphUserSettingsInner object itself.
     */
    public MicrosoftGraphUserSettingsInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphUserSettingsInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (shiftPreferences() != null) {
            shiftPreferences().validate();
        }
    }
}
