// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** todo. */
@Fluent
public final class MicrosoftGraphTodoInner extends MicrosoftGraphEntity {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphTodoInner.class);

    /*
     * The task lists in the users mailbox.
     */
    @JsonProperty(value = "lists")
    private List<MicrosoftGraphTodoTaskListInner> lists;

    /*
     * todo
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the lists property: The task lists in the users mailbox.
     *
     * @return the lists value.
     */
    public List<MicrosoftGraphTodoTaskListInner> lists() {
        return this.lists;
    }

    /**
     * Set the lists property: The task lists in the users mailbox.
     *
     * @param lists the lists value to set.
     * @return the MicrosoftGraphTodoInner object itself.
     */
    public MicrosoftGraphTodoInner withLists(List<MicrosoftGraphTodoTaskListInner> lists) {
        this.lists = lists;
        return this;
    }

    /**
     * Get the additionalProperties property: todo.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: todo.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphTodoInner object itself.
     */
    public MicrosoftGraphTodoInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphTodoInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (lists() != null) {
            lists().forEach(e -> e.validate());
        }
    }
}
