// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

/** timeOffRequest. */
@Fluent
public final class MicrosoftGraphTimeOffRequest extends MicrosoftGraphScheduleChangeRequest {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphTimeOffRequest.class);

    /*
     * The Timestamp type represents date and time information using ISO 8601
     * format and is always in UTC time. For example, midnight UTC on Jan 1,
     * 2014 would look like this: '2014-01-01T00:00:00Z'
     */
    @JsonProperty(value = "endDateTime")
    private OffsetDateTime endDateTime;

    /*
     * The Timestamp type represents date and time information using ISO 8601
     * format and is always in UTC time. For example, midnight UTC on Jan 1,
     * 2014 would look like this: '2014-01-01T00:00:00Z'
     */
    @JsonProperty(value = "startDateTime")
    private OffsetDateTime startDateTime;

    /*
     * The reason for the time off.
     */
    @JsonProperty(value = "timeOffReasonId")
    private String timeOffReasonId;

    /*
     * timeOffRequest
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the endDateTime property: The Timestamp type represents date and time information using ISO 8601 format and
     * is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     *
     * @return the endDateTime value.
     */
    public OffsetDateTime endDateTime() {
        return this.endDateTime;
    }

    /**
     * Set the endDateTime property: The Timestamp type represents date and time information using ISO 8601 format and
     * is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     *
     * @param endDateTime the endDateTime value to set.
     * @return the MicrosoftGraphTimeOffRequest object itself.
     */
    public MicrosoftGraphTimeOffRequest withEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    /**
     * Get the startDateTime property: The Timestamp type represents date and time information using ISO 8601 format and
     * is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     *
     * @return the startDateTime value.
     */
    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    /**
     * Set the startDateTime property: The Timestamp type represents date and time information using ISO 8601 format and
     * is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     *
     * @param startDateTime the startDateTime value to set.
     * @return the MicrosoftGraphTimeOffRequest object itself.
     */
    public MicrosoftGraphTimeOffRequest withStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    /**
     * Get the timeOffReasonId property: The reason for the time off.
     *
     * @return the timeOffReasonId value.
     */
    public String timeOffReasonId() {
        return this.timeOffReasonId;
    }

    /**
     * Set the timeOffReasonId property: The reason for the time off.
     *
     * @param timeOffReasonId the timeOffReasonId value to set.
     * @return the MicrosoftGraphTimeOffRequest object itself.
     */
    public MicrosoftGraphTimeOffRequest withTimeOffReasonId(String timeOffReasonId) {
        this.timeOffReasonId = timeOffReasonId;
        return this;
    }

    /**
     * Get the additionalProperties property: timeOffRequest.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: timeOffRequest.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphTimeOffRequest object itself.
     */
    public MicrosoftGraphTimeOffRequest withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphTimeOffRequest withAssignedTo(MicrosoftGraphScheduleChangeRequestActor assignedTo) {
        super.withAssignedTo(assignedTo);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphTimeOffRequest withManagerActionDateTime(OffsetDateTime managerActionDateTime) {
        super.withManagerActionDateTime(managerActionDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphTimeOffRequest withManagerActionMessage(String managerActionMessage) {
        super.withManagerActionMessage(managerActionMessage);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphTimeOffRequest withManagerUserId(String managerUserId) {
        super.withManagerUserId(managerUserId);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphTimeOffRequest withSenderDateTime(OffsetDateTime senderDateTime) {
        super.withSenderDateTime(senderDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphTimeOffRequest withSenderMessage(String senderMessage) {
        super.withSenderMessage(senderMessage);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphTimeOffRequest withSenderUserId(String senderUserId) {
        super.withSenderUserId(senderUserId);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphTimeOffRequest withState(MicrosoftGraphScheduleChangeState state) {
        super.withState(state);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphTimeOffRequest withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphTimeOffRequest withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphTimeOffRequest withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphTimeOffRequest withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
