// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** teamsTab. */
@Fluent
public final class MicrosoftGraphTeamsTab extends MicrosoftGraphEntity {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphTeamsTab.class);

    /*
     * teamsTabConfiguration
     */
    @JsonProperty(value = "configuration")
    private MicrosoftGraphTeamsTabConfiguration configuration;

    /*
     * Name of the tab.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * Deep link URL of the tab instance. Read only.
     */
    @JsonProperty(value = "webUrl")
    private String webUrl;

    /*
     * teamsApp
     */
    @JsonProperty(value = "teamsApp")
    private MicrosoftGraphTeamsApp teamsApp;

    /*
     * teamsTab
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the configuration property: teamsTabConfiguration.
     *
     * @return the configuration value.
     */
    public MicrosoftGraphTeamsTabConfiguration configuration() {
        return this.configuration;
    }

    /**
     * Set the configuration property: teamsTabConfiguration.
     *
     * @param configuration the configuration value to set.
     * @return the MicrosoftGraphTeamsTab object itself.
     */
    public MicrosoftGraphTeamsTab withConfiguration(MicrosoftGraphTeamsTabConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    /**
     * Get the displayName property: Name of the tab.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Name of the tab.
     *
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphTeamsTab object itself.
     */
    public MicrosoftGraphTeamsTab withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the webUrl property: Deep link URL of the tab instance. Read only.
     *
     * @return the webUrl value.
     */
    public String webUrl() {
        return this.webUrl;
    }

    /**
     * Set the webUrl property: Deep link URL of the tab instance. Read only.
     *
     * @param webUrl the webUrl value to set.
     * @return the MicrosoftGraphTeamsTab object itself.
     */
    public MicrosoftGraphTeamsTab withWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    /**
     * Get the teamsApp property: teamsApp.
     *
     * @return the teamsApp value.
     */
    public MicrosoftGraphTeamsApp teamsApp() {
        return this.teamsApp;
    }

    /**
     * Set the teamsApp property: teamsApp.
     *
     * @param teamsApp the teamsApp value to set.
     * @return the MicrosoftGraphTeamsTab object itself.
     */
    public MicrosoftGraphTeamsTab withTeamsApp(MicrosoftGraphTeamsApp teamsApp) {
        this.teamsApp = teamsApp;
        return this;
    }

    /**
     * Get the additionalProperties property: teamsTab.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: teamsTab.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphTeamsTab object itself.
     */
    public MicrosoftGraphTeamsTab withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphTeamsTab withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (configuration() != null) {
            configuration().validate();
        }
        if (teamsApp() != null) {
            teamsApp().validate();
        }
    }
}
