// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** singleValueLegacyExtendedProperty. */
@Fluent
public final class MicrosoftGraphSingleValueLegacyExtendedProperty extends MicrosoftGraphEntity {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(MicrosoftGraphSingleValueLegacyExtendedProperty.class);

    /*
     * A property value.
     */
    @JsonProperty(value = "value")
    private String value;

    /*
     * singleValueLegacyExtendedProperty
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the value property: A property value.
     *
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: A property value.
     *
     * @param value the value value to set.
     * @return the MicrosoftGraphSingleValueLegacyExtendedProperty object itself.
     */
    public MicrosoftGraphSingleValueLegacyExtendedProperty withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the additionalProperties property: singleValueLegacyExtendedProperty.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: singleValueLegacyExtendedProperty.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphSingleValueLegacyExtendedProperty object itself.
     */
    public MicrosoftGraphSingleValueLegacyExtendedProperty withAdditionalProperties(
        Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphSingleValueLegacyExtendedProperty withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
