// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** sharedInsight. */
@Fluent
public final class MicrosoftGraphSharedInsight extends MicrosoftGraphEntity {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphSharedInsight.class);

    /*
     * sharingDetail
     */
    @JsonProperty(value = "lastShared")
    private MicrosoftGraphSharingDetail lastShared;

    /*
     * resourceReference
     */
    @JsonProperty(value = "resourceReference")
    private MicrosoftGraphResourceReference resourceReference;

    /*
     * resourceVisualization
     */
    @JsonProperty(value = "resourceVisualization")
    private MicrosoftGraphResourceVisualization resourceVisualization;

    /*
     * The sharingHistory property.
     */
    @JsonProperty(value = "sharingHistory")
    private List<MicrosoftGraphSharingDetail> sharingHistory;

    /*
     * entity
     */
    @JsonProperty(value = "lastSharedMethod")
    private MicrosoftGraphEntity lastSharedMethod;

    /*
     * entity
     */
    @JsonProperty(value = "resource")
    private MicrosoftGraphEntity resource;

    /*
     * sharedInsight
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the lastShared property: sharingDetail.
     *
     * @return the lastShared value.
     */
    public MicrosoftGraphSharingDetail lastShared() {
        return this.lastShared;
    }

    /**
     * Set the lastShared property: sharingDetail.
     *
     * @param lastShared the lastShared value to set.
     * @return the MicrosoftGraphSharedInsight object itself.
     */
    public MicrosoftGraphSharedInsight withLastShared(MicrosoftGraphSharingDetail lastShared) {
        this.lastShared = lastShared;
        return this;
    }

    /**
     * Get the resourceReference property: resourceReference.
     *
     * @return the resourceReference value.
     */
    public MicrosoftGraphResourceReference resourceReference() {
        return this.resourceReference;
    }

    /**
     * Set the resourceReference property: resourceReference.
     *
     * @param resourceReference the resourceReference value to set.
     * @return the MicrosoftGraphSharedInsight object itself.
     */
    public MicrosoftGraphSharedInsight withResourceReference(MicrosoftGraphResourceReference resourceReference) {
        this.resourceReference = resourceReference;
        return this;
    }

    /**
     * Get the resourceVisualization property: resourceVisualization.
     *
     * @return the resourceVisualization value.
     */
    public MicrosoftGraphResourceVisualization resourceVisualization() {
        return this.resourceVisualization;
    }

    /**
     * Set the resourceVisualization property: resourceVisualization.
     *
     * @param resourceVisualization the resourceVisualization value to set.
     * @return the MicrosoftGraphSharedInsight object itself.
     */
    public MicrosoftGraphSharedInsight withResourceVisualization(
        MicrosoftGraphResourceVisualization resourceVisualization) {
        this.resourceVisualization = resourceVisualization;
        return this;
    }

    /**
     * Get the sharingHistory property: The sharingHistory property.
     *
     * @return the sharingHistory value.
     */
    public List<MicrosoftGraphSharingDetail> sharingHistory() {
        return this.sharingHistory;
    }

    /**
     * Set the sharingHistory property: The sharingHistory property.
     *
     * @param sharingHistory the sharingHistory value to set.
     * @return the MicrosoftGraphSharedInsight object itself.
     */
    public MicrosoftGraphSharedInsight withSharingHistory(List<MicrosoftGraphSharingDetail> sharingHistory) {
        this.sharingHistory = sharingHistory;
        return this;
    }

    /**
     * Get the lastSharedMethod property: entity.
     *
     * @return the lastSharedMethod value.
     */
    public MicrosoftGraphEntity lastSharedMethod() {
        return this.lastSharedMethod;
    }

    /**
     * Set the lastSharedMethod property: entity.
     *
     * @param lastSharedMethod the lastSharedMethod value to set.
     * @return the MicrosoftGraphSharedInsight object itself.
     */
    public MicrosoftGraphSharedInsight withLastSharedMethod(MicrosoftGraphEntity lastSharedMethod) {
        this.lastSharedMethod = lastSharedMethod;
        return this;
    }

    /**
     * Get the resource property: entity.
     *
     * @return the resource value.
     */
    public MicrosoftGraphEntity resource() {
        return this.resource;
    }

    /**
     * Set the resource property: entity.
     *
     * @param resource the resource value to set.
     * @return the MicrosoftGraphSharedInsight object itself.
     */
    public MicrosoftGraphSharedInsight withResource(MicrosoftGraphEntity resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Get the additionalProperties property: sharedInsight.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: sharedInsight.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphSharedInsight object itself.
     */
    public MicrosoftGraphSharedInsight withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphSharedInsight withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (lastShared() != null) {
            lastShared().validate();
        }
        if (resourceReference() != null) {
            resourceReference().validate();
        }
        if (resourceVisualization() != null) {
            resourceVisualization().validate();
        }
        if (sharingHistory() != null) {
            sharingHistory().forEach(e -> e.validate());
        }
        if (lastSharedMethod() != null) {
            lastSharedMethod().validate();
        }
        if (resource() != null) {
            resource().validate();
        }
    }
}
