// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/** resourceAccess. */
@Fluent
public final class MicrosoftGraphResourceAccess {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphResourceAccess.class);

    /*
     * The unique identifier for one of the oauth2PermissionScopes or appRole
     * instances that the resource application exposes.
     */
    @JsonProperty(value = "id")
    private UUID id;

    /*
     * Specifies whether the id property references an oauth2PermissionScopes
     * or an appRole. Possible values are Scope or Role.
     */
    @JsonProperty(value = "type")
    private String type;

    /*
     * resourceAccess
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the id property: The unique identifier for one of the oauth2PermissionScopes or appRole instances that the
     * resource application exposes.
     *
     * @return the id value.
     */
    public UUID id() {
        return this.id;
    }

    /**
     * Set the id property: The unique identifier for one of the oauth2PermissionScopes or appRole instances that the
     * resource application exposes.
     *
     * @param id the id value to set.
     * @return the MicrosoftGraphResourceAccess object itself.
     */
    public MicrosoftGraphResourceAccess withId(UUID id) {
        this.id = id;
        return this;
    }

    /**
     * Get the type property: Specifies whether the id property references an oauth2PermissionScopes or an appRole.
     * Possible values are Scope or Role.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Specifies whether the id property references an oauth2PermissionScopes or an appRole.
     * Possible values are Scope or Role.
     *
     * @param type the type value to set.
     * @return the MicrosoftGraphResourceAccess object itself.
     */
    public MicrosoftGraphResourceAccess withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the additionalProperties property: resourceAccess.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: resourceAccess.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphResourceAccess object itself.
     */
    public MicrosoftGraphResourceAccess withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
