// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** publicClientApplication. */
@Fluent
public final class MicrosoftGraphPublicClientApplication {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphPublicClientApplication.class);

    /*
     * Specifies the URLs where user tokens are sent for sign-in, or the
     * redirect URIs where OAuth 2.0 authorization codes and access tokens are
     * sent.
     */
    @JsonProperty(value = "redirectUris")
    private List<String> redirectUris;

    /*
     * publicClientApplication
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the redirectUris property: Specifies the URLs where user tokens are sent for sign-in, or the redirect URIs
     * where OAuth 2.0 authorization codes and access tokens are sent.
     *
     * @return the redirectUris value.
     */
    public List<String> redirectUris() {
        return this.redirectUris;
    }

    /**
     * Set the redirectUris property: Specifies the URLs where user tokens are sent for sign-in, or the redirect URIs
     * where OAuth 2.0 authorization codes and access tokens are sent.
     *
     * @param redirectUris the redirectUris value to set.
     * @return the MicrosoftGraphPublicClientApplication object itself.
     */
    public MicrosoftGraphPublicClientApplication withRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
        return this;
    }

    /**
     * Get the additionalProperties property: publicClientApplication.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: publicClientApplication.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPublicClientApplication object itself.
     */
    public MicrosoftGraphPublicClientApplication withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
