// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** plannerPlanDetails. */
@Fluent
public final class MicrosoftGraphPlannerPlanDetails extends MicrosoftGraphEntity {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphPlannerPlanDetails.class);

    /*
     * plannerCategoryDescriptions
     */
    @JsonProperty(value = "categoryDescriptions")
    private MicrosoftGraphPlannerCategoryDescriptions categoryDescriptions;

    /*
     * plannerUserIds
     */
    @JsonProperty(value = "sharedWith")
    private Map<String, Object> sharedWith;

    /*
     * plannerPlanDetails
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the categoryDescriptions property: plannerCategoryDescriptions.
     *
     * @return the categoryDescriptions value.
     */
    public MicrosoftGraphPlannerCategoryDescriptions categoryDescriptions() {
        return this.categoryDescriptions;
    }

    /**
     * Set the categoryDescriptions property: plannerCategoryDescriptions.
     *
     * @param categoryDescriptions the categoryDescriptions value to set.
     * @return the MicrosoftGraphPlannerPlanDetails object itself.
     */
    public MicrosoftGraphPlannerPlanDetails withCategoryDescriptions(
        MicrosoftGraphPlannerCategoryDescriptions categoryDescriptions) {
        this.categoryDescriptions = categoryDescriptions;
        return this;
    }

    /**
     * Get the sharedWith property: plannerUserIds.
     *
     * @return the sharedWith value.
     */
    public Map<String, Object> sharedWith() {
        return this.sharedWith;
    }

    /**
     * Set the sharedWith property: plannerUserIds.
     *
     * @param sharedWith the sharedWith value to set.
     * @return the MicrosoftGraphPlannerPlanDetails object itself.
     */
    public MicrosoftGraphPlannerPlanDetails withSharedWith(Map<String, Object> sharedWith) {
        this.sharedWith = sharedWith;
        return this;
    }

    /**
     * Get the additionalProperties property: plannerPlanDetails.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: plannerPlanDetails.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPlannerPlanDetails object itself.
     */
    public MicrosoftGraphPlannerPlanDetails withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphPlannerPlanDetails withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (categoryDescriptions() != null) {
            categoryDescriptions().validate();
        }
    }
}
