// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

/** offerShiftRequest. */
@Fluent
public class MicrosoftGraphOfferShiftRequest extends MicrosoftGraphScheduleChangeRequest {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphOfferShiftRequest.class);

    /*
     * The Timestamp type represents date and time information using ISO 8601
     * format and is always in UTC time. For example, midnight UTC on Jan 1,
     * 2014 would look like this: '2014-01-01T00:00:00Z'
     */
    @JsonProperty(value = "recipientActionDateTime")
    private OffsetDateTime recipientActionDateTime;

    /*
     * Custom message sent by recipient of the offer shift request.
     */
    @JsonProperty(value = "recipientActionMessage")
    private String recipientActionMessage;

    /*
     * User ID of the recipient of the offer shift request.
     */
    @JsonProperty(value = "recipientUserId")
    private String recipientUserId;

    /*
     * User ID of the sender of the offer shift request.
     */
    @JsonProperty(value = "senderShiftId")
    private String senderShiftId;

    /*
     * offerShiftRequest
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the recipientActionDateTime property: The Timestamp type represents date and time information using ISO 8601
     * format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'.
     *
     * @return the recipientActionDateTime value.
     */
    public OffsetDateTime recipientActionDateTime() {
        return this.recipientActionDateTime;
    }

    /**
     * Set the recipientActionDateTime property: The Timestamp type represents date and time information using ISO 8601
     * format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'.
     *
     * @param recipientActionDateTime the recipientActionDateTime value to set.
     * @return the MicrosoftGraphOfferShiftRequest object itself.
     */
    public MicrosoftGraphOfferShiftRequest withRecipientActionDateTime(OffsetDateTime recipientActionDateTime) {
        this.recipientActionDateTime = recipientActionDateTime;
        return this;
    }

    /**
     * Get the recipientActionMessage property: Custom message sent by recipient of the offer shift request.
     *
     * @return the recipientActionMessage value.
     */
    public String recipientActionMessage() {
        return this.recipientActionMessage;
    }

    /**
     * Set the recipientActionMessage property: Custom message sent by recipient of the offer shift request.
     *
     * @param recipientActionMessage the recipientActionMessage value to set.
     * @return the MicrosoftGraphOfferShiftRequest object itself.
     */
    public MicrosoftGraphOfferShiftRequest withRecipientActionMessage(String recipientActionMessage) {
        this.recipientActionMessage = recipientActionMessage;
        return this;
    }

    /**
     * Get the recipientUserId property: User ID of the recipient of the offer shift request.
     *
     * @return the recipientUserId value.
     */
    public String recipientUserId() {
        return this.recipientUserId;
    }

    /**
     * Set the recipientUserId property: User ID of the recipient of the offer shift request.
     *
     * @param recipientUserId the recipientUserId value to set.
     * @return the MicrosoftGraphOfferShiftRequest object itself.
     */
    public MicrosoftGraphOfferShiftRequest withRecipientUserId(String recipientUserId) {
        this.recipientUserId = recipientUserId;
        return this;
    }

    /**
     * Get the senderShiftId property: User ID of the sender of the offer shift request.
     *
     * @return the senderShiftId value.
     */
    public String senderShiftId() {
        return this.senderShiftId;
    }

    /**
     * Set the senderShiftId property: User ID of the sender of the offer shift request.
     *
     * @param senderShiftId the senderShiftId value to set.
     * @return the MicrosoftGraphOfferShiftRequest object itself.
     */
    public MicrosoftGraphOfferShiftRequest withSenderShiftId(String senderShiftId) {
        this.senderShiftId = senderShiftId;
        return this;
    }

    /**
     * Get the additionalProperties property: offerShiftRequest.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: offerShiftRequest.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOfferShiftRequest object itself.
     */
    public MicrosoftGraphOfferShiftRequest withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOfferShiftRequest withAssignedTo(MicrosoftGraphScheduleChangeRequestActor assignedTo) {
        super.withAssignedTo(assignedTo);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOfferShiftRequest withManagerActionDateTime(OffsetDateTime managerActionDateTime) {
        super.withManagerActionDateTime(managerActionDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOfferShiftRequest withManagerActionMessage(String managerActionMessage) {
        super.withManagerActionMessage(managerActionMessage);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOfferShiftRequest withManagerUserId(String managerUserId) {
        super.withManagerUserId(managerUserId);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOfferShiftRequest withSenderDateTime(OffsetDateTime senderDateTime) {
        super.withSenderDateTime(senderDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOfferShiftRequest withSenderMessage(String senderMessage) {
        super.withSenderMessage(senderMessage);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOfferShiftRequest withSenderUserId(String senderUserId) {
        super.withSenderUserId(senderUserId);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOfferShiftRequest withState(MicrosoftGraphScheduleChangeState state) {
        super.withState(state);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOfferShiftRequest withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOfferShiftRequest withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOfferShiftRequest withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOfferShiftRequest withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
