// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** message. */
@Fluent
public final class MicrosoftGraphMessage extends MicrosoftGraphOutlookItem {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphMessage.class);

    /*
     * The Bcc: recipients for the message.
     */
    @JsonProperty(value = "bccRecipients")
    private List<MicrosoftGraphRecipient> bccRecipients;

    /*
     * itemBody
     */
    @JsonProperty(value = "body")
    private MicrosoftGraphItemBody body;

    /*
     * The first 255 characters of the message body. It is in text format.
     */
    @JsonProperty(value = "bodyPreview")
    private String bodyPreview;

    /*
     * The Cc: recipients for the message.
     */
    @JsonProperty(value = "ccRecipients")
    private List<MicrosoftGraphRecipient> ccRecipients;

    /*
     * The ID of the conversation the email belongs to.
     */
    @JsonProperty(value = "conversationId")
    private String conversationId;

    /*
     * Indicates the position of the message within the conversation.
     */
    @JsonProperty(value = "conversationIndex")
    private Base64Url conversationIndex;

    /*
     * followupFlag
     */
    @JsonProperty(value = "flag")
    private MicrosoftGraphFollowupFlag flag;

    /*
     * recipient
     */
    @JsonProperty(value = "from")
    private MicrosoftGraphRecipient from;

    /*
     * Indicates whether the message has attachments. This property doesn't
     * include inline attachments, so if a message contains only inline
     * attachments, this property is false. To verify the existence of inline
     * attachments, parse the body property to look for a src attribute, such
     * as <IMG src='cid:image001.jpg@01D26CD8.6C05F070'>.
     */
    @JsonProperty(value = "hasAttachments")
    private Boolean hasAttachments;

    /*
     * The importance property.
     */
    @JsonProperty(value = "importance")
    private MicrosoftGraphImportance importance;

    /*
     * The inferenceClassification property.
     */
    @JsonProperty(value = "inferenceClassification")
    private MicrosoftGraphInferenceClassificationType inferenceClassification;

    /*
     * A collection of message headers defined by RFC5322. The set includes
     * message headers indicating the network path taken by a message from the
     * sender to the recipient. It can also contain custom message headers that
     * hold app data for the message.  Returned only on applying a $select
     * query option. Read-only.
     */
    @JsonProperty(value = "internetMessageHeaders")
    private List<MicrosoftGraphInternetMessageHeader> internetMessageHeaders;

    /*
     * The message ID in the format specified by RFC2822.
     */
    @JsonProperty(value = "internetMessageId")
    private String internetMessageId;

    /*
     * Indicates whether a read receipt is requested for the message.
     */
    @JsonProperty(value = "isDeliveryReceiptRequested")
    private Boolean isDeliveryReceiptRequested;

    /*
     * Indicates whether the message is a draft. A message is a draft if it
     * hasn't been sent yet.
     */
    @JsonProperty(value = "isDraft")
    private Boolean isDraft;

    /*
     * Indicates whether the message has been read.
     */
    @JsonProperty(value = "isRead")
    private Boolean isRead;

    /*
     * Indicates whether a read receipt is requested for the message.
     */
    @JsonProperty(value = "isReadReceiptRequested")
    private Boolean isReadReceiptRequested;

    /*
     * The unique identifier for the message's parent mailFolder.
     */
    @JsonProperty(value = "parentFolderId")
    private String parentFolderId;

    /*
     * The date and time the message was received.  The date and time
     * information uses ISO 8601 format and is always in UTC time. For example,
     * midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'.
     */
    @JsonProperty(value = "receivedDateTime")
    private OffsetDateTime receivedDateTime;

    /*
     * The email addresses to use when replying.
     */
    @JsonProperty(value = "replyTo")
    private List<MicrosoftGraphRecipient> replyTo;

    /*
     * recipient
     */
    @JsonProperty(value = "sender")
    private MicrosoftGraphRecipient sender;

    /*
     * The date and time the message was sent.  The date and time information
     * uses ISO 8601 format and is always in UTC time. For example, midnight
     * UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     */
    @JsonProperty(value = "sentDateTime")
    private OffsetDateTime sentDateTime;

    /*
     * The subject of the message.
     */
    @JsonProperty(value = "subject")
    private String subject;

    /*
     * The To: recipients for the message.
     */
    @JsonProperty(value = "toRecipients")
    private List<MicrosoftGraphRecipient> toRecipients;

    /*
     * itemBody
     */
    @JsonProperty(value = "uniqueBody")
    private MicrosoftGraphItemBody uniqueBody;

    /*
     * The URL to open the message in Outlook on the web.You can append an
     * ispopout argument to the end of the URL to change how the message is
     * displayed. If ispopout is not present or if it is set to 1, then the
     * message is shown in a popout window. If ispopout is set to 0, then the
     * browser will show the message in the Outlook on the web review pane.The
     * message will open in the browser if you are logged in to your mailbox
     * via Outlook on the web. You will be prompted to login if you are not
     * already logged in with the browser.This URL cannot be accessed from
     * within an iFrame.
     */
    @JsonProperty(value = "webLink")
    private String webLink;

    /*
     * The fileAttachment and itemAttachment attachments for the message.
     */
    @JsonProperty(value = "attachments")
    private List<MicrosoftGraphAttachment> attachments;

    /*
     * The collection of open extensions defined for the message. Nullable.
     */
    @JsonProperty(value = "extensions")
    private List<MicrosoftGraphExtensionInner> extensions;

    /*
     * The collection of multi-value extended properties defined for the
     * message. Nullable.
     */
    @JsonProperty(value = "multiValueExtendedProperties")
    private List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties;

    /*
     * The collection of single-value extended properties defined for the
     * message. Nullable.
     */
    @JsonProperty(value = "singleValueExtendedProperties")
    private List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties;

    /*
     * message
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the bccRecipients property: The Bcc: recipients for the message.
     *
     * @return the bccRecipients value.
     */
    public List<MicrosoftGraphRecipient> bccRecipients() {
        return this.bccRecipients;
    }

    /**
     * Set the bccRecipients property: The Bcc: recipients for the message.
     *
     * @param bccRecipients the bccRecipients value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withBccRecipients(List<MicrosoftGraphRecipient> bccRecipients) {
        this.bccRecipients = bccRecipients;
        return this;
    }

    /**
     * Get the body property: itemBody.
     *
     * @return the body value.
     */
    public MicrosoftGraphItemBody body() {
        return this.body;
    }

    /**
     * Set the body property: itemBody.
     *
     * @param body the body value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withBody(MicrosoftGraphItemBody body) {
        this.body = body;
        return this;
    }

    /**
     * Get the bodyPreview property: The first 255 characters of the message body. It is in text format.
     *
     * @return the bodyPreview value.
     */
    public String bodyPreview() {
        return this.bodyPreview;
    }

    /**
     * Set the bodyPreview property: The first 255 characters of the message body. It is in text format.
     *
     * @param bodyPreview the bodyPreview value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withBodyPreview(String bodyPreview) {
        this.bodyPreview = bodyPreview;
        return this;
    }

    /**
     * Get the ccRecipients property: The Cc: recipients for the message.
     *
     * @return the ccRecipients value.
     */
    public List<MicrosoftGraphRecipient> ccRecipients() {
        return this.ccRecipients;
    }

    /**
     * Set the ccRecipients property: The Cc: recipients for the message.
     *
     * @param ccRecipients the ccRecipients value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withCcRecipients(List<MicrosoftGraphRecipient> ccRecipients) {
        this.ccRecipients = ccRecipients;
        return this;
    }

    /**
     * Get the conversationId property: The ID of the conversation the email belongs to.
     *
     * @return the conversationId value.
     */
    public String conversationId() {
        return this.conversationId;
    }

    /**
     * Set the conversationId property: The ID of the conversation the email belongs to.
     *
     * @param conversationId the conversationId value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withConversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    /**
     * Get the conversationIndex property: Indicates the position of the message within the conversation.
     *
     * @return the conversationIndex value.
     */
    public byte[] conversationIndex() {
        if (this.conversationIndex == null) {
            return null;
        }
        return this.conversationIndex.decodedBytes();
    }

    /**
     * Set the conversationIndex property: Indicates the position of the message within the conversation.
     *
     * @param conversationIndex the conversationIndex value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withConversationIndex(byte[] conversationIndex) {
        if (conversationIndex == null) {
            this.conversationIndex = null;
        } else {
            this.conversationIndex = Base64Url.encode(CoreUtils.clone(conversationIndex));
        }
        return this;
    }

    /**
     * Get the flag property: followupFlag.
     *
     * @return the flag value.
     */
    public MicrosoftGraphFollowupFlag flag() {
        return this.flag;
    }

    /**
     * Set the flag property: followupFlag.
     *
     * @param flag the flag value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withFlag(MicrosoftGraphFollowupFlag flag) {
        this.flag = flag;
        return this;
    }

    /**
     * Get the from property: recipient.
     *
     * @return the from value.
     */
    public MicrosoftGraphRecipient from() {
        return this.from;
    }

    /**
     * Set the from property: recipient.
     *
     * @param from the from value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withFrom(MicrosoftGraphRecipient from) {
        this.from = from;
        return this;
    }

    /**
     * Get the hasAttachments property: Indicates whether the message has attachments. This property doesn't include
     * inline attachments, so if a message contains only inline attachments, this property is false. To verify the
     * existence of inline attachments, parse the body property to look for a src attribute, such as &lt;IMG
     * src='cid:image001.jpg@01D26CD8.6C05F070'&gt;.
     *
     * @return the hasAttachments value.
     */
    public Boolean hasAttachments() {
        return this.hasAttachments;
    }

    /**
     * Set the hasAttachments property: Indicates whether the message has attachments. This property doesn't include
     * inline attachments, so if a message contains only inline attachments, this property is false. To verify the
     * existence of inline attachments, parse the body property to look for a src attribute, such as &lt;IMG
     * src='cid:image001.jpg@01D26CD8.6C05F070'&gt;.
     *
     * @param hasAttachments the hasAttachments value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withHasAttachments(Boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
        return this;
    }

    /**
     * Get the importance property: The importance property.
     *
     * @return the importance value.
     */
    public MicrosoftGraphImportance importance() {
        return this.importance;
    }

    /**
     * Set the importance property: The importance property.
     *
     * @param importance the importance value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withImportance(MicrosoftGraphImportance importance) {
        this.importance = importance;
        return this;
    }

    /**
     * Get the inferenceClassification property: The inferenceClassification property.
     *
     * @return the inferenceClassification value.
     */
    public MicrosoftGraphInferenceClassificationType inferenceClassification() {
        return this.inferenceClassification;
    }

    /**
     * Set the inferenceClassification property: The inferenceClassification property.
     *
     * @param inferenceClassification the inferenceClassification value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withInferenceClassification(
        MicrosoftGraphInferenceClassificationType inferenceClassification) {
        this.inferenceClassification = inferenceClassification;
        return this;
    }

    /**
     * Get the internetMessageHeaders property: A collection of message headers defined by RFC5322. The set includes
     * message headers indicating the network path taken by a message from the sender to the recipient. It can also
     * contain custom message headers that hold app data for the message. Returned only on applying a $select query
     * option. Read-only.
     *
     * @return the internetMessageHeaders value.
     */
    public List<MicrosoftGraphInternetMessageHeader> internetMessageHeaders() {
        return this.internetMessageHeaders;
    }

    /**
     * Set the internetMessageHeaders property: A collection of message headers defined by RFC5322. The set includes
     * message headers indicating the network path taken by a message from the sender to the recipient. It can also
     * contain custom message headers that hold app data for the message. Returned only on applying a $select query
     * option. Read-only.
     *
     * @param internetMessageHeaders the internetMessageHeaders value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withInternetMessageHeaders(
        List<MicrosoftGraphInternetMessageHeader> internetMessageHeaders) {
        this.internetMessageHeaders = internetMessageHeaders;
        return this;
    }

    /**
     * Get the internetMessageId property: The message ID in the format specified by RFC2822.
     *
     * @return the internetMessageId value.
     */
    public String internetMessageId() {
        return this.internetMessageId;
    }

    /**
     * Set the internetMessageId property: The message ID in the format specified by RFC2822.
     *
     * @param internetMessageId the internetMessageId value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withInternetMessageId(String internetMessageId) {
        this.internetMessageId = internetMessageId;
        return this;
    }

    /**
     * Get the isDeliveryReceiptRequested property: Indicates whether a read receipt is requested for the message.
     *
     * @return the isDeliveryReceiptRequested value.
     */
    public Boolean isDeliveryReceiptRequested() {
        return this.isDeliveryReceiptRequested;
    }

    /**
     * Set the isDeliveryReceiptRequested property: Indicates whether a read receipt is requested for the message.
     *
     * @param isDeliveryReceiptRequested the isDeliveryReceiptRequested value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withIsDeliveryReceiptRequested(Boolean isDeliveryReceiptRequested) {
        this.isDeliveryReceiptRequested = isDeliveryReceiptRequested;
        return this;
    }

    /**
     * Get the isDraft property: Indicates whether the message is a draft. A message is a draft if it hasn't been sent
     * yet.
     *
     * @return the isDraft value.
     */
    public Boolean isDraft() {
        return this.isDraft;
    }

    /**
     * Set the isDraft property: Indicates whether the message is a draft. A message is a draft if it hasn't been sent
     * yet.
     *
     * @param isDraft the isDraft value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withIsDraft(Boolean isDraft) {
        this.isDraft = isDraft;
        return this;
    }

    /**
     * Get the isRead property: Indicates whether the message has been read.
     *
     * @return the isRead value.
     */
    public Boolean isRead() {
        return this.isRead;
    }

    /**
     * Set the isRead property: Indicates whether the message has been read.
     *
     * @param isRead the isRead value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withIsRead(Boolean isRead) {
        this.isRead = isRead;
        return this;
    }

    /**
     * Get the isReadReceiptRequested property: Indicates whether a read receipt is requested for the message.
     *
     * @return the isReadReceiptRequested value.
     */
    public Boolean isReadReceiptRequested() {
        return this.isReadReceiptRequested;
    }

    /**
     * Set the isReadReceiptRequested property: Indicates whether a read receipt is requested for the message.
     *
     * @param isReadReceiptRequested the isReadReceiptRequested value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withIsReadReceiptRequested(Boolean isReadReceiptRequested) {
        this.isReadReceiptRequested = isReadReceiptRequested;
        return this;
    }

    /**
     * Get the parentFolderId property: The unique identifier for the message's parent mailFolder.
     *
     * @return the parentFolderId value.
     */
    public String parentFolderId() {
        return this.parentFolderId;
    }

    /**
     * Set the parentFolderId property: The unique identifier for the message's parent mailFolder.
     *
     * @param parentFolderId the parentFolderId value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withParentFolderId(String parentFolderId) {
        this.parentFolderId = parentFolderId;
        return this;
    }

    /**
     * Get the receivedDateTime property: The date and time the message was received. The date and time information uses
     * ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'.
     *
     * @return the receivedDateTime value.
     */
    public OffsetDateTime receivedDateTime() {
        return this.receivedDateTime;
    }

    /**
     * Set the receivedDateTime property: The date and time the message was received. The date and time information uses
     * ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'.
     *
     * @param receivedDateTime the receivedDateTime value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withReceivedDateTime(OffsetDateTime receivedDateTime) {
        this.receivedDateTime = receivedDateTime;
        return this;
    }

    /**
     * Get the replyTo property: The email addresses to use when replying.
     *
     * @return the replyTo value.
     */
    public List<MicrosoftGraphRecipient> replyTo() {
        return this.replyTo;
    }

    /**
     * Set the replyTo property: The email addresses to use when replying.
     *
     * @param replyTo the replyTo value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withReplyTo(List<MicrosoftGraphRecipient> replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    /**
     * Get the sender property: recipient.
     *
     * @return the sender value.
     */
    public MicrosoftGraphRecipient sender() {
        return this.sender;
    }

    /**
     * Set the sender property: recipient.
     *
     * @param sender the sender value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withSender(MicrosoftGraphRecipient sender) {
        this.sender = sender;
        return this;
    }

    /**
     * Get the sentDateTime property: The date and time the message was sent. The date and time information uses ISO
     * 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'.
     *
     * @return the sentDateTime value.
     */
    public OffsetDateTime sentDateTime() {
        return this.sentDateTime;
    }

    /**
     * Set the sentDateTime property: The date and time the message was sent. The date and time information uses ISO
     * 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'.
     *
     * @param sentDateTime the sentDateTime value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withSentDateTime(OffsetDateTime sentDateTime) {
        this.sentDateTime = sentDateTime;
        return this;
    }

    /**
     * Get the subject property: The subject of the message.
     *
     * @return the subject value.
     */
    public String subject() {
        return this.subject;
    }

    /**
     * Set the subject property: The subject of the message.
     *
     * @param subject the subject value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    /**
     * Get the toRecipients property: The To: recipients for the message.
     *
     * @return the toRecipients value.
     */
    public List<MicrosoftGraphRecipient> toRecipients() {
        return this.toRecipients;
    }

    /**
     * Set the toRecipients property: The To: recipients for the message.
     *
     * @param toRecipients the toRecipients value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withToRecipients(List<MicrosoftGraphRecipient> toRecipients) {
        this.toRecipients = toRecipients;
        return this;
    }

    /**
     * Get the uniqueBody property: itemBody.
     *
     * @return the uniqueBody value.
     */
    public MicrosoftGraphItemBody uniqueBody() {
        return this.uniqueBody;
    }

    /**
     * Set the uniqueBody property: itemBody.
     *
     * @param uniqueBody the uniqueBody value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withUniqueBody(MicrosoftGraphItemBody uniqueBody) {
        this.uniqueBody = uniqueBody;
        return this;
    }

    /**
     * Get the webLink property: The URL to open the message in Outlook on the web.You can append an ispopout argument
     * to the end of the URL to change how the message is displayed. If ispopout is not present or if it is set to 1,
     * then the message is shown in a popout window. If ispopout is set to 0, then the browser will show the message in
     * the Outlook on the web review pane.The message will open in the browser if you are logged in to your mailbox via
     * Outlook on the web. You will be prompted to login if you are not already logged in with the browser.This URL
     * cannot be accessed from within an iFrame.
     *
     * @return the webLink value.
     */
    public String webLink() {
        return this.webLink;
    }

    /**
     * Set the webLink property: The URL to open the message in Outlook on the web.You can append an ispopout argument
     * to the end of the URL to change how the message is displayed. If ispopout is not present or if it is set to 1,
     * then the message is shown in a popout window. If ispopout is set to 0, then the browser will show the message in
     * the Outlook on the web review pane.The message will open in the browser if you are logged in to your mailbox via
     * Outlook on the web. You will be prompted to login if you are not already logged in with the browser.This URL
     * cannot be accessed from within an iFrame.
     *
     * @param webLink the webLink value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withWebLink(String webLink) {
        this.webLink = webLink;
        return this;
    }

    /**
     * Get the attachments property: The fileAttachment and itemAttachment attachments for the message.
     *
     * @return the attachments value.
     */
    public List<MicrosoftGraphAttachment> attachments() {
        return this.attachments;
    }

    /**
     * Set the attachments property: The fileAttachment and itemAttachment attachments for the message.
     *
     * @param attachments the attachments value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withAttachments(List<MicrosoftGraphAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    /**
     * Get the extensions property: The collection of open extensions defined for the message. Nullable.
     *
     * @return the extensions value.
     */
    public List<MicrosoftGraphExtensionInner> extensions() {
        return this.extensions;
    }

    /**
     * Set the extensions property: The collection of open extensions defined for the message. Nullable.
     *
     * @param extensions the extensions value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withExtensions(List<MicrosoftGraphExtensionInner> extensions) {
        this.extensions = extensions;
        return this;
    }

    /**
     * Get the multiValueExtendedProperties property: The collection of multi-value extended properties defined for the
     * message. Nullable.
     *
     * @return the multiValueExtendedProperties value.
     */
    public List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties() {
        return this.multiValueExtendedProperties;
    }

    /**
     * Set the multiValueExtendedProperties property: The collection of multi-value extended properties defined for the
     * message. Nullable.
     *
     * @param multiValueExtendedProperties the multiValueExtendedProperties value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withMultiValueExtendedProperties(
        List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
        this.multiValueExtendedProperties = multiValueExtendedProperties;
        return this;
    }

    /**
     * Get the singleValueExtendedProperties property: The collection of single-value extended properties defined for
     * the message. Nullable.
     *
     * @return the singleValueExtendedProperties value.
     */
    public List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties() {
        return this.singleValueExtendedProperties;
    }

    /**
     * Set the singleValueExtendedProperties property: The collection of single-value extended properties defined for
     * the message. Nullable.
     *
     * @param singleValueExtendedProperties the singleValueExtendedProperties value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withSingleValueExtendedProperties(
        List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
        this.singleValueExtendedProperties = singleValueExtendedProperties;
        return this;
    }

    /**
     * Get the additionalProperties property: message.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: message.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphMessage object itself.
     */
    public MicrosoftGraphMessage withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphMessage withCategories(List<String> categories) {
        super.withCategories(categories);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphMessage withChangeKey(String changeKey) {
        super.withChangeKey(changeKey);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphMessage withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphMessage withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphMessage withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (bccRecipients() != null) {
            bccRecipients().forEach(e -> e.validate());
        }
        if (body() != null) {
            body().validate();
        }
        if (ccRecipients() != null) {
            ccRecipients().forEach(e -> e.validate());
        }
        if (flag() != null) {
            flag().validate();
        }
        if (from() != null) {
            from().validate();
        }
        if (internetMessageHeaders() != null) {
            internetMessageHeaders().forEach(e -> e.validate());
        }
        if (replyTo() != null) {
            replyTo().forEach(e -> e.validate());
        }
        if (sender() != null) {
            sender().validate();
        }
        if (toRecipients() != null) {
            toRecipients().forEach(e -> e.validate());
        }
        if (uniqueBody() != null) {
            uniqueBody().validate();
        }
        if (attachments() != null) {
            attachments().forEach(e -> e.validate());
        }
        if (extensions() != null) {
            extensions().forEach(e -> e.validate());
        }
        if (multiValueExtendedProperties() != null) {
            multiValueExtendedProperties().forEach(e -> e.validate());
        }
        if (singleValueExtendedProperties() != null) {
            singleValueExtendedProperties().forEach(e -> e.validate());
        }
    }
}
