// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** lookupColumn. */
@Fluent
public final class MicrosoftGraphLookupColumn {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphLookupColumn.class);

    /*
     * Indicates whether multiple values can be selected from the source.
     */
    @JsonProperty(value = "allowMultipleValues")
    private Boolean allowMultipleValues;

    /*
     * Indicates whether values in the column should be able to exceed the
     * standard limit of 255 characters.
     */
    @JsonProperty(value = "allowUnlimitedLength")
    private Boolean allowUnlimitedLength;

    /*
     * The name of the lookup source column.
     */
    @JsonProperty(value = "columnName")
    private String columnName;

    /*
     * The unique identifier of the lookup source list.
     */
    @JsonProperty(value = "listId")
    private String listId;

    /*
     * If specified, this column is a secondary lookup, pulling an additional
     * field from the list item looked up by the primary lookup. Use the list
     * item looked up by the primary as the source for the column named here.
     */
    @JsonProperty(value = "primaryLookupColumnId")
    private String primaryLookupColumnId;

    /*
     * lookupColumn
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the allowMultipleValues property: Indicates whether multiple values can be selected from the source.
     *
     * @return the allowMultipleValues value.
     */
    public Boolean allowMultipleValues() {
        return this.allowMultipleValues;
    }

    /**
     * Set the allowMultipleValues property: Indicates whether multiple values can be selected from the source.
     *
     * @param allowMultipleValues the allowMultipleValues value to set.
     * @return the MicrosoftGraphLookupColumn object itself.
     */
    public MicrosoftGraphLookupColumn withAllowMultipleValues(Boolean allowMultipleValues) {
        this.allowMultipleValues = allowMultipleValues;
        return this;
    }

    /**
     * Get the allowUnlimitedLength property: Indicates whether values in the column should be able to exceed the
     * standard limit of 255 characters.
     *
     * @return the allowUnlimitedLength value.
     */
    public Boolean allowUnlimitedLength() {
        return this.allowUnlimitedLength;
    }

    /**
     * Set the allowUnlimitedLength property: Indicates whether values in the column should be able to exceed the
     * standard limit of 255 characters.
     *
     * @param allowUnlimitedLength the allowUnlimitedLength value to set.
     * @return the MicrosoftGraphLookupColumn object itself.
     */
    public MicrosoftGraphLookupColumn withAllowUnlimitedLength(Boolean allowUnlimitedLength) {
        this.allowUnlimitedLength = allowUnlimitedLength;
        return this;
    }

    /**
     * Get the columnName property: The name of the lookup source column.
     *
     * @return the columnName value.
     */
    public String columnName() {
        return this.columnName;
    }

    /**
     * Set the columnName property: The name of the lookup source column.
     *
     * @param columnName the columnName value to set.
     * @return the MicrosoftGraphLookupColumn object itself.
     */
    public MicrosoftGraphLookupColumn withColumnName(String columnName) {
        this.columnName = columnName;
        return this;
    }

    /**
     * Get the listId property: The unique identifier of the lookup source list.
     *
     * @return the listId value.
     */
    public String listId() {
        return this.listId;
    }

    /**
     * Set the listId property: The unique identifier of the lookup source list.
     *
     * @param listId the listId value to set.
     * @return the MicrosoftGraphLookupColumn object itself.
     */
    public MicrosoftGraphLookupColumn withListId(String listId) {
        this.listId = listId;
        return this;
    }

    /**
     * Get the primaryLookupColumnId property: If specified, this column is a secondary lookup, pulling an additional
     * field from the list item looked up by the primary lookup. Use the list item looked up by the primary as the
     * source for the column named here.
     *
     * @return the primaryLookupColumnId value.
     */
    public String primaryLookupColumnId() {
        return this.primaryLookupColumnId;
    }

    /**
     * Set the primaryLookupColumnId property: If specified, this column is a secondary lookup, pulling an additional
     * field from the list item looked up by the primary lookup. Use the list item looked up by the primary as the
     * source for the column named here.
     *
     * @param primaryLookupColumnId the primaryLookupColumnId value to set.
     * @return the MicrosoftGraphLookupColumn object itself.
     */
    public MicrosoftGraphLookupColumn withPrimaryLookupColumnId(String primaryLookupColumnId) {
        this.primaryLookupColumnId = primaryLookupColumnId;
        return this;
    }

    /**
     * Get the additionalProperties property: lookupColumn.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: lookupColumn.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphLookupColumn object itself.
     */
    public MicrosoftGraphLookupColumn withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
