// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** list. */
@Fluent
public final class MicrosoftGraphList extends MicrosoftGraphBaseItemInner {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphList.class);

    /*
     * The displayable title of the list.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * listInfo
     */
    @JsonProperty(value = "list")
    private MicrosoftGraphListInfo list;

    /*
     * sharepointIds
     */
    @JsonProperty(value = "sharepointIds")
    private MicrosoftGraphSharepointIds sharepointIds;

    /*
     * systemFacet
     */
    @JsonProperty(value = "system")
    private Map<String, Object> system;

    /*
     * The collection of field definitions for this list.
     */
    @JsonProperty(value = "columns")
    private List<MicrosoftGraphColumnDefinition> columns;

    /*
     * The collection of content types present in this list.
     */
    @JsonProperty(value = "contentTypes")
    private List<MicrosoftGraphContentType> contentTypes;

    /*
     * drive
     */
    @JsonProperty(value = "drive")
    private MicrosoftGraphDrive drive;

    /*
     * All items contained in the list.
     */
    @JsonProperty(value = "items")
    private List<MicrosoftGraphListItem> items;

    /*
     * The set of subscriptions on the list.
     */
    @JsonProperty(value = "subscriptions")
    private List<MicrosoftGraphSubscription> subscriptions;

    /*
     * list
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the displayName property: The displayable title of the list.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The displayable title of the list.
     *
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphList object itself.
     */
    public MicrosoftGraphList withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the list property: listInfo.
     *
     * @return the list value.
     */
    public MicrosoftGraphListInfo list() {
        return this.list;
    }

    /**
     * Set the list property: listInfo.
     *
     * @param list the list value to set.
     * @return the MicrosoftGraphList object itself.
     */
    public MicrosoftGraphList withList(MicrosoftGraphListInfo list) {
        this.list = list;
        return this;
    }

    /**
     * Get the sharepointIds property: sharepointIds.
     *
     * @return the sharepointIds value.
     */
    public MicrosoftGraphSharepointIds sharepointIds() {
        return this.sharepointIds;
    }

    /**
     * Set the sharepointIds property: sharepointIds.
     *
     * @param sharepointIds the sharepointIds value to set.
     * @return the MicrosoftGraphList object itself.
     */
    public MicrosoftGraphList withSharepointIds(MicrosoftGraphSharepointIds sharepointIds) {
        this.sharepointIds = sharepointIds;
        return this;
    }

    /**
     * Get the system property: systemFacet.
     *
     * @return the system value.
     */
    public Map<String, Object> system() {
        return this.system;
    }

    /**
     * Set the system property: systemFacet.
     *
     * @param system the system value to set.
     * @return the MicrosoftGraphList object itself.
     */
    public MicrosoftGraphList withSystem(Map<String, Object> system) {
        this.system = system;
        return this;
    }

    /**
     * Get the columns property: The collection of field definitions for this list.
     *
     * @return the columns value.
     */
    public List<MicrosoftGraphColumnDefinition> columns() {
        return this.columns;
    }

    /**
     * Set the columns property: The collection of field definitions for this list.
     *
     * @param columns the columns value to set.
     * @return the MicrosoftGraphList object itself.
     */
    public MicrosoftGraphList withColumns(List<MicrosoftGraphColumnDefinition> columns) {
        this.columns = columns;
        return this;
    }

    /**
     * Get the contentTypes property: The collection of content types present in this list.
     *
     * @return the contentTypes value.
     */
    public List<MicrosoftGraphContentType> contentTypes() {
        return this.contentTypes;
    }

    /**
     * Set the contentTypes property: The collection of content types present in this list.
     *
     * @param contentTypes the contentTypes value to set.
     * @return the MicrosoftGraphList object itself.
     */
    public MicrosoftGraphList withContentTypes(List<MicrosoftGraphContentType> contentTypes) {
        this.contentTypes = contentTypes;
        return this;
    }

    /**
     * Get the drive property: drive.
     *
     * @return the drive value.
     */
    public MicrosoftGraphDrive drive() {
        return this.drive;
    }

    /**
     * Set the drive property: drive.
     *
     * @param drive the drive value to set.
     * @return the MicrosoftGraphList object itself.
     */
    public MicrosoftGraphList withDrive(MicrosoftGraphDrive drive) {
        this.drive = drive;
        return this;
    }

    /**
     * Get the items property: All items contained in the list.
     *
     * @return the items value.
     */
    public List<MicrosoftGraphListItem> items() {
        return this.items;
    }

    /**
     * Set the items property: All items contained in the list.
     *
     * @param items the items value to set.
     * @return the MicrosoftGraphList object itself.
     */
    public MicrosoftGraphList withItems(List<MicrosoftGraphListItem> items) {
        this.items = items;
        return this;
    }

    /**
     * Get the subscriptions property: The set of subscriptions on the list.
     *
     * @return the subscriptions value.
     */
    public List<MicrosoftGraphSubscription> subscriptions() {
        return this.subscriptions;
    }

    /**
     * Set the subscriptions property: The set of subscriptions on the list.
     *
     * @param subscriptions the subscriptions value to set.
     * @return the MicrosoftGraphList object itself.
     */
    public MicrosoftGraphList withSubscriptions(List<MicrosoftGraphSubscription> subscriptions) {
        this.subscriptions = subscriptions;
        return this;
    }

    /**
     * Get the additionalProperties property: list.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: list.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphList object itself.
     */
    public MicrosoftGraphList withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphList withCreatedBy(MicrosoftGraphIdentitySet createdBy) {
        super.withCreatedBy(createdBy);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphList withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphList withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphList withEtag(String etag) {
        super.withEtag(etag);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphList withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphList withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphList withName(String name) {
        super.withName(name);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphList withParentReference(MicrosoftGraphItemReference parentReference) {
        super.withParentReference(parentReference);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphList withWebUrl(String webUrl) {
        super.withWebUrl(webUrl);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphList withCreatedByUser(MicrosoftGraphUserInner createdByUser) {
        super.withCreatedByUser(createdByUser);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphList withLastModifiedByUser(MicrosoftGraphUserInner lastModifiedByUser) {
        super.withLastModifiedByUser(lastModifiedByUser);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphList withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (list() != null) {
            list().validate();
        }
        if (sharepointIds() != null) {
            sharepointIds().validate();
        }
        if (columns() != null) {
            columns().forEach(e -> e.validate());
        }
        if (contentTypes() != null) {
            contentTypes().forEach(e -> e.validate());
        }
        if (drive() != null) {
            drive().validate();
        }
        if (items() != null) {
            items().forEach(e -> e.validate());
        }
        if (subscriptions() != null) {
            subscriptions().forEach(e -> e.validate());
        }
    }
}
