// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

/** itemActivity. */
@Fluent
public final class MicrosoftGraphItemActivity extends MicrosoftGraphEntity {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphItemActivity.class);

    /*
     * accessAction
     */
    @JsonProperty(value = "access")
    private Map<String, Object> access;

    /*
     * Details about when the activity took place. Read-only.
     */
    @JsonProperty(value = "activityDateTime")
    private OffsetDateTime activityDateTime;

    /*
     * identitySet
     */
    @JsonProperty(value = "actor")
    private MicrosoftGraphIdentitySet actor;

    /*
     * driveItem
     */
    @JsonProperty(value = "driveItem")
    private MicrosoftGraphDriveItem driveItem;

    /*
     * itemActivity
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the access property: accessAction.
     *
     * @return the access value.
     */
    public Map<String, Object> access() {
        return this.access;
    }

    /**
     * Set the access property: accessAction.
     *
     * @param access the access value to set.
     * @return the MicrosoftGraphItemActivity object itself.
     */
    public MicrosoftGraphItemActivity withAccess(Map<String, Object> access) {
        this.access = access;
        return this;
    }

    /**
     * Get the activityDateTime property: Details about when the activity took place. Read-only.
     *
     * @return the activityDateTime value.
     */
    public OffsetDateTime activityDateTime() {
        return this.activityDateTime;
    }

    /**
     * Set the activityDateTime property: Details about when the activity took place. Read-only.
     *
     * @param activityDateTime the activityDateTime value to set.
     * @return the MicrosoftGraphItemActivity object itself.
     */
    public MicrosoftGraphItemActivity withActivityDateTime(OffsetDateTime activityDateTime) {
        this.activityDateTime = activityDateTime;
        return this;
    }

    /**
     * Get the actor property: identitySet.
     *
     * @return the actor value.
     */
    public MicrosoftGraphIdentitySet actor() {
        return this.actor;
    }

    /**
     * Set the actor property: identitySet.
     *
     * @param actor the actor value to set.
     * @return the MicrosoftGraphItemActivity object itself.
     */
    public MicrosoftGraphItemActivity withActor(MicrosoftGraphIdentitySet actor) {
        this.actor = actor;
        return this;
    }

    /**
     * Get the driveItem property: driveItem.
     *
     * @return the driveItem value.
     */
    public MicrosoftGraphDriveItem driveItem() {
        return this.driveItem;
    }

    /**
     * Set the driveItem property: driveItem.
     *
     * @param driveItem the driveItem value to set.
     * @return the MicrosoftGraphItemActivity object itself.
     */
    public MicrosoftGraphItemActivity withDriveItem(MicrosoftGraphDriveItem driveItem) {
        this.driveItem = driveItem;
        return this;
    }

    /**
     * Get the additionalProperties property: itemActivity.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: itemActivity.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphItemActivity object itself.
     */
    public MicrosoftGraphItemActivity withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphItemActivity withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (actor() != null) {
            actor().validate();
        }
        if (driveItem() != null) {
            driveItem().validate();
        }
    }
}
