// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** entity. */
@Fluent
public class MicrosoftGraphEntity {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphEntity.class);

    /*
     * Read-only.
     */
    @JsonProperty(value = "id")
    private String id;

    /*
     * entity
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the id property: Read-only.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Read-only.
     *
     * @param id the id value to set.
     * @return the MicrosoftGraphEntity object itself.
     */
    public MicrosoftGraphEntity withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the additionalProperties property: entity.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: entity.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphEntity object itself.
     */
    public MicrosoftGraphEntity withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
