// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

/** Event representing an general failure. */
@Fluent
public final class MicrosoftGraphDeviceManagementTroubleshootingEvent extends MicrosoftGraphEntity {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(MicrosoftGraphDeviceManagementTroubleshootingEvent.class);

    /*
     * Id used for tracing the failure in the service.
     */
    @JsonProperty(value = "correlationId")
    private String correlationId;

    /*
     * Time when the event occurred .
     */
    @JsonProperty(value = "eventDateTime")
    private OffsetDateTime eventDateTime;

    /*
     * Event representing an general failure.
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the correlationId property: Id used for tracing the failure in the service.
     *
     * @return the correlationId value.
     */
    public String correlationId() {
        return this.correlationId;
    }

    /**
     * Set the correlationId property: Id used for tracing the failure in the service.
     *
     * @param correlationId the correlationId value to set.
     * @return the MicrosoftGraphDeviceManagementTroubleshootingEvent object itself.
     */
    public MicrosoftGraphDeviceManagementTroubleshootingEvent withCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    /**
     * Get the eventDateTime property: Time when the event occurred .
     *
     * @return the eventDateTime value.
     */
    public OffsetDateTime eventDateTime() {
        return this.eventDateTime;
    }

    /**
     * Set the eventDateTime property: Time when the event occurred .
     *
     * @param eventDateTime the eventDateTime value to set.
     * @return the MicrosoftGraphDeviceManagementTroubleshootingEvent object itself.
     */
    public MicrosoftGraphDeviceManagementTroubleshootingEvent withEventDateTime(OffsetDateTime eventDateTime) {
        this.eventDateTime = eventDateTime;
        return this;
    }

    /**
     * Get the additionalProperties property: Event representing an general failure.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Event representing an general failure.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphDeviceManagementTroubleshootingEvent object itself.
     */
    public MicrosoftGraphDeviceManagementTroubleshootingEvent withAdditionalProperties(
        Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphDeviceManagementTroubleshootingEvent withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
