// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** contact. */
@Fluent
public final class MicrosoftGraphContactInner extends MicrosoftGraphOutlookItem {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphContactInner.class);

    /*
     * The name of the contact's assistant.
     */
    @JsonProperty(value = "assistantName")
    private String assistantName;

    /*
     * The contact's birthday. The Timestamp type represents date and time
     * information using ISO 8601 format and is always in UTC time. For
     * example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'
     */
    @JsonProperty(value = "birthday")
    private OffsetDateTime birthday;

    /*
     * physicalAddress
     */
    @JsonProperty(value = "businessAddress")
    private MicrosoftGraphPhysicalAddress businessAddress;

    /*
     * The business home page of the contact.
     */
    @JsonProperty(value = "businessHomePage")
    private String businessHomePage;

    /*
     * The contact's business phone numbers.
     */
    @JsonProperty(value = "businessPhones")
    private List<String> businessPhones;

    /*
     * The names of the contact's children.
     */
    @JsonProperty(value = "children")
    private List<String> children;

    /*
     * The name of the contact's company.
     */
    @JsonProperty(value = "companyName")
    private String companyName;

    /*
     * The contact's department.
     */
    @JsonProperty(value = "department")
    private String department;

    /*
     * The contact's display name. You can specify the display name in a create
     * or update operation. Note that later updates to other properties may
     * cause an automatically generated value to overwrite the displayName
     * value you have specified. To preserve a pre-existing value, always
     * include it as displayName in an update operation.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * The contact's email addresses.
     */
    @JsonProperty(value = "emailAddresses")
    private List<MicrosoftGraphEmailAddress> emailAddresses;

    /*
     * The name the contact is filed under.
     */
    @JsonProperty(value = "fileAs")
    private String fileAs;

    /*
     * The contact's generation.
     */
    @JsonProperty(value = "generation")
    private String generation;

    /*
     * The contact's given name.
     */
    @JsonProperty(value = "givenName")
    private String givenName;

    /*
     * physicalAddress
     */
    @JsonProperty(value = "homeAddress")
    private MicrosoftGraphPhysicalAddress homeAddress;

    /*
     * The contact's home phone numbers.
     */
    @JsonProperty(value = "homePhones")
    private List<String> homePhones;

    /*
     * The contact's instant messaging (IM) addresses.
     */
    @JsonProperty(value = "imAddresses")
    private List<String> imAddresses;

    /*
     * The contact's initials.
     */
    @JsonProperty(value = "initials")
    private String initials;

    /*
     * The contact’s job title.
     */
    @JsonProperty(value = "jobTitle")
    private String jobTitle;

    /*
     * The name of the contact's manager.
     */
    @JsonProperty(value = "manager")
    private String manager;

    /*
     * The contact's middle name.
     */
    @JsonProperty(value = "middleName")
    private String middleName;

    /*
     * The contact's mobile phone number.
     */
    @JsonProperty(value = "mobilePhone")
    private String mobilePhone;

    /*
     * The contact's nickname.
     */
    @JsonProperty(value = "nickName")
    private String nickName;

    /*
     * The location of the contact's office.
     */
    @JsonProperty(value = "officeLocation")
    private String officeLocation;

    /*
     * physicalAddress
     */
    @JsonProperty(value = "otherAddress")
    private MicrosoftGraphPhysicalAddress otherAddress;

    /*
     * The ID of the contact's parent folder.
     */
    @JsonProperty(value = "parentFolderId")
    private String parentFolderId;

    /*
     * The user's notes about the contact.
     */
    @JsonProperty(value = "personalNotes")
    private String personalNotes;

    /*
     * The contact's profession.
     */
    @JsonProperty(value = "profession")
    private String profession;

    /*
     * The name of the contact's spouse/partner.
     */
    @JsonProperty(value = "spouseName")
    private String spouseName;

    /*
     * The contact's surname.
     */
    @JsonProperty(value = "surname")
    private String surname;

    /*
     * The contact's title.
     */
    @JsonProperty(value = "title")
    private String title;

    /*
     * The phonetic Japanese company name of the contact.
     */
    @JsonProperty(value = "yomiCompanyName")
    private String yomiCompanyName;

    /*
     * The phonetic Japanese given name (first name) of the contact.
     */
    @JsonProperty(value = "yomiGivenName")
    private String yomiGivenName;

    /*
     * The phonetic Japanese surname (last name)  of the contact.
     */
    @JsonProperty(value = "yomiSurname")
    private String yomiSurname;

    /*
     * The collection of open extensions defined for the contact. Read-only.
     * Nullable.
     */
    @JsonProperty(value = "extensions")
    private List<MicrosoftGraphExtensionInner> extensions;

    /*
     * The collection of multi-value extended properties defined for the
     * contact. Read-only. Nullable.
     */
    @JsonProperty(value = "multiValueExtendedProperties")
    private List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties;

    /*
     * profilePhoto
     */
    @JsonProperty(value = "photo")
    private MicrosoftGraphProfilePhotoInner photo;

    /*
     * The collection of single-value extended properties defined for the
     * contact. Read-only. Nullable.
     */
    @JsonProperty(value = "singleValueExtendedProperties")
    private List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties;

    /*
     * contact
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the assistantName property: The name of the contact's assistant.
     *
     * @return the assistantName value.
     */
    public String assistantName() {
        return this.assistantName;
    }

    /**
     * Set the assistantName property: The name of the contact's assistant.
     *
     * @param assistantName the assistantName value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withAssistantName(String assistantName) {
        this.assistantName = assistantName;
        return this;
    }

    /**
     * Get the birthday property: The contact's birthday. The Timestamp type represents date and time information using
     * ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'.
     *
     * @return the birthday value.
     */
    public OffsetDateTime birthday() {
        return this.birthday;
    }

    /**
     * Set the birthday property: The contact's birthday. The Timestamp type represents date and time information using
     * ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'.
     *
     * @param birthday the birthday value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withBirthday(OffsetDateTime birthday) {
        this.birthday = birthday;
        return this;
    }

    /**
     * Get the businessAddress property: physicalAddress.
     *
     * @return the businessAddress value.
     */
    public MicrosoftGraphPhysicalAddress businessAddress() {
        return this.businessAddress;
    }

    /**
     * Set the businessAddress property: physicalAddress.
     *
     * @param businessAddress the businessAddress value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withBusinessAddress(MicrosoftGraphPhysicalAddress businessAddress) {
        this.businessAddress = businessAddress;
        return this;
    }

    /**
     * Get the businessHomePage property: The business home page of the contact.
     *
     * @return the businessHomePage value.
     */
    public String businessHomePage() {
        return this.businessHomePage;
    }

    /**
     * Set the businessHomePage property: The business home page of the contact.
     *
     * @param businessHomePage the businessHomePage value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withBusinessHomePage(String businessHomePage) {
        this.businessHomePage = businessHomePage;
        return this;
    }

    /**
     * Get the businessPhones property: The contact's business phone numbers.
     *
     * @return the businessPhones value.
     */
    public List<String> businessPhones() {
        return this.businessPhones;
    }

    /**
     * Set the businessPhones property: The contact's business phone numbers.
     *
     * @param businessPhones the businessPhones value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withBusinessPhones(List<String> businessPhones) {
        this.businessPhones = businessPhones;
        return this;
    }

    /**
     * Get the children property: The names of the contact's children.
     *
     * @return the children value.
     */
    public List<String> children() {
        return this.children;
    }

    /**
     * Set the children property: The names of the contact's children.
     *
     * @param children the children value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withChildren(List<String> children) {
        this.children = children;
        return this;
    }

    /**
     * Get the companyName property: The name of the contact's company.
     *
     * @return the companyName value.
     */
    public String companyName() {
        return this.companyName;
    }

    /**
     * Set the companyName property: The name of the contact's company.
     *
     * @param companyName the companyName value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    /**
     * Get the department property: The contact's department.
     *
     * @return the department value.
     */
    public String department() {
        return this.department;
    }

    /**
     * Set the department property: The contact's department.
     *
     * @param department the department value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withDepartment(String department) {
        this.department = department;
        return this;
    }

    /**
     * Get the displayName property: The contact's display name. You can specify the display name in a create or update
     * operation. Note that later updates to other properties may cause an automatically generated value to overwrite
     * the displayName value you have specified. To preserve a pre-existing value, always include it as displayName in
     * an update operation.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The contact's display name. You can specify the display name in a create or update
     * operation. Note that later updates to other properties may cause an automatically generated value to overwrite
     * the displayName value you have specified. To preserve a pre-existing value, always include it as displayName in
     * an update operation.
     *
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the emailAddresses property: The contact's email addresses.
     *
     * @return the emailAddresses value.
     */
    public List<MicrosoftGraphEmailAddress> emailAddresses() {
        return this.emailAddresses;
    }

    /**
     * Set the emailAddresses property: The contact's email addresses.
     *
     * @param emailAddresses the emailAddresses value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withEmailAddresses(List<MicrosoftGraphEmailAddress> emailAddresses) {
        this.emailAddresses = emailAddresses;
        return this;
    }

    /**
     * Get the fileAs property: The name the contact is filed under.
     *
     * @return the fileAs value.
     */
    public String fileAs() {
        return this.fileAs;
    }

    /**
     * Set the fileAs property: The name the contact is filed under.
     *
     * @param fileAs the fileAs value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withFileAs(String fileAs) {
        this.fileAs = fileAs;
        return this;
    }

    /**
     * Get the generation property: The contact's generation.
     *
     * @return the generation value.
     */
    public String generation() {
        return this.generation;
    }

    /**
     * Set the generation property: The contact's generation.
     *
     * @param generation the generation value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withGeneration(String generation) {
        this.generation = generation;
        return this;
    }

    /**
     * Get the givenName property: The contact's given name.
     *
     * @return the givenName value.
     */
    public String givenName() {
        return this.givenName;
    }

    /**
     * Set the givenName property: The contact's given name.
     *
     * @param givenName the givenName value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withGivenName(String givenName) {
        this.givenName = givenName;
        return this;
    }

    /**
     * Get the homeAddress property: physicalAddress.
     *
     * @return the homeAddress value.
     */
    public MicrosoftGraphPhysicalAddress homeAddress() {
        return this.homeAddress;
    }

    /**
     * Set the homeAddress property: physicalAddress.
     *
     * @param homeAddress the homeAddress value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withHomeAddress(MicrosoftGraphPhysicalAddress homeAddress) {
        this.homeAddress = homeAddress;
        return this;
    }

    /**
     * Get the homePhones property: The contact's home phone numbers.
     *
     * @return the homePhones value.
     */
    public List<String> homePhones() {
        return this.homePhones;
    }

    /**
     * Set the homePhones property: The contact's home phone numbers.
     *
     * @param homePhones the homePhones value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withHomePhones(List<String> homePhones) {
        this.homePhones = homePhones;
        return this;
    }

    /**
     * Get the imAddresses property: The contact's instant messaging (IM) addresses.
     *
     * @return the imAddresses value.
     */
    public List<String> imAddresses() {
        return this.imAddresses;
    }

    /**
     * Set the imAddresses property: The contact's instant messaging (IM) addresses.
     *
     * @param imAddresses the imAddresses value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withImAddresses(List<String> imAddresses) {
        this.imAddresses = imAddresses;
        return this;
    }

    /**
     * Get the initials property: The contact's initials.
     *
     * @return the initials value.
     */
    public String initials() {
        return this.initials;
    }

    /**
     * Set the initials property: The contact's initials.
     *
     * @param initials the initials value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withInitials(String initials) {
        this.initials = initials;
        return this;
    }

    /**
     * Get the jobTitle property: The contact’s job title.
     *
     * @return the jobTitle value.
     */
    public String jobTitle() {
        return this.jobTitle;
    }

    /**
     * Set the jobTitle property: The contact’s job title.
     *
     * @param jobTitle the jobTitle value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
        return this;
    }

    /**
     * Get the manager property: The name of the contact's manager.
     *
     * @return the manager value.
     */
    public String manager() {
        return this.manager;
    }

    /**
     * Set the manager property: The name of the contact's manager.
     *
     * @param manager the manager value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withManager(String manager) {
        this.manager = manager;
        return this;
    }

    /**
     * Get the middleName property: The contact's middle name.
     *
     * @return the middleName value.
     */
    public String middleName() {
        return this.middleName;
    }

    /**
     * Set the middleName property: The contact's middle name.
     *
     * @param middleName the middleName value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withMiddleName(String middleName) {
        this.middleName = middleName;
        return this;
    }

    /**
     * Get the mobilePhone property: The contact's mobile phone number.
     *
     * @return the mobilePhone value.
     */
    public String mobilePhone() {
        return this.mobilePhone;
    }

    /**
     * Set the mobilePhone property: The contact's mobile phone number.
     *
     * @param mobilePhone the mobilePhone value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
        return this;
    }

    /**
     * Get the nickName property: The contact's nickname.
     *
     * @return the nickName value.
     */
    public String nickName() {
        return this.nickName;
    }

    /**
     * Set the nickName property: The contact's nickname.
     *
     * @param nickName the nickName value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withNickName(String nickName) {
        this.nickName = nickName;
        return this;
    }

    /**
     * Get the officeLocation property: The location of the contact's office.
     *
     * @return the officeLocation value.
     */
    public String officeLocation() {
        return this.officeLocation;
    }

    /**
     * Set the officeLocation property: The location of the contact's office.
     *
     * @param officeLocation the officeLocation value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withOfficeLocation(String officeLocation) {
        this.officeLocation = officeLocation;
        return this;
    }

    /**
     * Get the otherAddress property: physicalAddress.
     *
     * @return the otherAddress value.
     */
    public MicrosoftGraphPhysicalAddress otherAddress() {
        return this.otherAddress;
    }

    /**
     * Set the otherAddress property: physicalAddress.
     *
     * @param otherAddress the otherAddress value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withOtherAddress(MicrosoftGraphPhysicalAddress otherAddress) {
        this.otherAddress = otherAddress;
        return this;
    }

    /**
     * Get the parentFolderId property: The ID of the contact's parent folder.
     *
     * @return the parentFolderId value.
     */
    public String parentFolderId() {
        return this.parentFolderId;
    }

    /**
     * Set the parentFolderId property: The ID of the contact's parent folder.
     *
     * @param parentFolderId the parentFolderId value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withParentFolderId(String parentFolderId) {
        this.parentFolderId = parentFolderId;
        return this;
    }

    /**
     * Get the personalNotes property: The user's notes about the contact.
     *
     * @return the personalNotes value.
     */
    public String personalNotes() {
        return this.personalNotes;
    }

    /**
     * Set the personalNotes property: The user's notes about the contact.
     *
     * @param personalNotes the personalNotes value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withPersonalNotes(String personalNotes) {
        this.personalNotes = personalNotes;
        return this;
    }

    /**
     * Get the profession property: The contact's profession.
     *
     * @return the profession value.
     */
    public String profession() {
        return this.profession;
    }

    /**
     * Set the profession property: The contact's profession.
     *
     * @param profession the profession value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withProfession(String profession) {
        this.profession = profession;
        return this;
    }

    /**
     * Get the spouseName property: The name of the contact's spouse/partner.
     *
     * @return the spouseName value.
     */
    public String spouseName() {
        return this.spouseName;
    }

    /**
     * Set the spouseName property: The name of the contact's spouse/partner.
     *
     * @param spouseName the spouseName value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withSpouseName(String spouseName) {
        this.spouseName = spouseName;
        return this;
    }

    /**
     * Get the surname property: The contact's surname.
     *
     * @return the surname value.
     */
    public String surname() {
        return this.surname;
    }

    /**
     * Set the surname property: The contact's surname.
     *
     * @param surname the surname value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withSurname(String surname) {
        this.surname = surname;
        return this;
    }

    /**
     * Get the title property: The contact's title.
     *
     * @return the title value.
     */
    public String title() {
        return this.title;
    }

    /**
     * Set the title property: The contact's title.
     *
     * @param title the title value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * Get the yomiCompanyName property: The phonetic Japanese company name of the contact.
     *
     * @return the yomiCompanyName value.
     */
    public String yomiCompanyName() {
        return this.yomiCompanyName;
    }

    /**
     * Set the yomiCompanyName property: The phonetic Japanese company name of the contact.
     *
     * @param yomiCompanyName the yomiCompanyName value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withYomiCompanyName(String yomiCompanyName) {
        this.yomiCompanyName = yomiCompanyName;
        return this;
    }

    /**
     * Get the yomiGivenName property: The phonetic Japanese given name (first name) of the contact.
     *
     * @return the yomiGivenName value.
     */
    public String yomiGivenName() {
        return this.yomiGivenName;
    }

    /**
     * Set the yomiGivenName property: The phonetic Japanese given name (first name) of the contact.
     *
     * @param yomiGivenName the yomiGivenName value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withYomiGivenName(String yomiGivenName) {
        this.yomiGivenName = yomiGivenName;
        return this;
    }

    /**
     * Get the yomiSurname property: The phonetic Japanese surname (last name) of the contact.
     *
     * @return the yomiSurname value.
     */
    public String yomiSurname() {
        return this.yomiSurname;
    }

    /**
     * Set the yomiSurname property: The phonetic Japanese surname (last name) of the contact.
     *
     * @param yomiSurname the yomiSurname value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withYomiSurname(String yomiSurname) {
        this.yomiSurname = yomiSurname;
        return this;
    }

    /**
     * Get the extensions property: The collection of open extensions defined for the contact. Read-only. Nullable.
     *
     * @return the extensions value.
     */
    public List<MicrosoftGraphExtensionInner> extensions() {
        return this.extensions;
    }

    /**
     * Set the extensions property: The collection of open extensions defined for the contact. Read-only. Nullable.
     *
     * @param extensions the extensions value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withExtensions(List<MicrosoftGraphExtensionInner> extensions) {
        this.extensions = extensions;
        return this;
    }

    /**
     * Get the multiValueExtendedProperties property: The collection of multi-value extended properties defined for the
     * contact. Read-only. Nullable.
     *
     * @return the multiValueExtendedProperties value.
     */
    public List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties() {
        return this.multiValueExtendedProperties;
    }

    /**
     * Set the multiValueExtendedProperties property: The collection of multi-value extended properties defined for the
     * contact. Read-only. Nullable.
     *
     * @param multiValueExtendedProperties the multiValueExtendedProperties value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withMultiValueExtendedProperties(
        List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
        this.multiValueExtendedProperties = multiValueExtendedProperties;
        return this;
    }

    /**
     * Get the photo property: profilePhoto.
     *
     * @return the photo value.
     */
    public MicrosoftGraphProfilePhotoInner photo() {
        return this.photo;
    }

    /**
     * Set the photo property: profilePhoto.
     *
     * @param photo the photo value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withPhoto(MicrosoftGraphProfilePhotoInner photo) {
        this.photo = photo;
        return this;
    }

    /**
     * Get the singleValueExtendedProperties property: The collection of single-value extended properties defined for
     * the contact. Read-only. Nullable.
     *
     * @return the singleValueExtendedProperties value.
     */
    public List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties() {
        return this.singleValueExtendedProperties;
    }

    /**
     * Set the singleValueExtendedProperties property: The collection of single-value extended properties defined for
     * the contact. Read-only. Nullable.
     *
     * @param singleValueExtendedProperties the singleValueExtendedProperties value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withSingleValueExtendedProperties(
        List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
        this.singleValueExtendedProperties = singleValueExtendedProperties;
        return this;
    }

    /**
     * Get the additionalProperties property: contact.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: contact.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphContactInner object itself.
     */
    public MicrosoftGraphContactInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphContactInner withCategories(List<String> categories) {
        super.withCategories(categories);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphContactInner withChangeKey(String changeKey) {
        super.withChangeKey(changeKey);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphContactInner withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphContactInner withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphContactInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (businessAddress() != null) {
            businessAddress().validate();
        }
        if (emailAddresses() != null) {
            emailAddresses().forEach(e -> e.validate());
        }
        if (homeAddress() != null) {
            homeAddress().validate();
        }
        if (otherAddress() != null) {
            otherAddress().validate();
        }
        if (extensions() != null) {
            extensions().forEach(e -> e.validate());
        }
        if (multiValueExtendedProperties() != null) {
            multiValueExtendedProperties().forEach(e -> e.validate());
        }
        if (photo() != null) {
            photo().validate();
        }
        if (singleValueExtendedProperties() != null) {
            singleValueExtendedProperties().forEach(e -> e.validate());
        }
    }
}
