// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** channel. */
@Fluent
public final class MicrosoftGraphChannel extends MicrosoftGraphEntity {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphChannel.class);

    /*
     * Optional textual description for the channel.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * Channel name as it will appear to the user in Microsoft Teams.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * The email address for sending messages to the channel. Read-only.
     */
    @JsonProperty(value = "email")
    private String email;

    /*
     * Indicates whether the channel should automatically be marked 'favorite'
     * for all members of the team. Can only be set programmatically with
     * Create team. Default: false.
     */
    @JsonProperty(value = "isFavoriteByDefault")
    private Boolean isFavoriteByDefault;

    /*
     * The membershipType property.
     */
    @JsonProperty(value = "membershipType")
    private MicrosoftGraphChannelMembershipType membershipType;

    /*
     * A hyperlink that will go to the channel in Microsoft Teams. This is the
     * URL that you get when you right-click a channel in Microsoft Teams and
     * select Get link to channel. This URL should be treated as an opaque
     * blob, and not parsed. Read-only.
     */
    @JsonProperty(value = "webUrl")
    private String webUrl;

    /*
     * driveItem
     */
    @JsonProperty(value = "filesFolder")
    private MicrosoftGraphDriveItem filesFolder;

    /*
     * A collection of membership records associated with the channel.
     */
    @JsonProperty(value = "members")
    private List<MicrosoftGraphConversationMember> members;

    /*
     * A collection of all the messages in the channel. A navigation property.
     * Nullable.
     */
    @JsonProperty(value = "messages")
    private List<MicrosoftGraphChatMessage> messages;

    /*
     * A collection of all the tabs in the channel. A navigation property.
     */
    @JsonProperty(value = "tabs")
    private List<MicrosoftGraphTeamsTab> tabs;

    /*
     * channel
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the description property: Optional textual description for the channel.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Optional textual description for the channel.
     *
     * @param description the description value to set.
     * @return the MicrosoftGraphChannel object itself.
     */
    public MicrosoftGraphChannel withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the displayName property: Channel name as it will appear to the user in Microsoft Teams.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Channel name as it will appear to the user in Microsoft Teams.
     *
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphChannel object itself.
     */
    public MicrosoftGraphChannel withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the email property: The email address for sending messages to the channel. Read-only.
     *
     * @return the email value.
     */
    public String email() {
        return this.email;
    }

    /**
     * Set the email property: The email address for sending messages to the channel. Read-only.
     *
     * @param email the email value to set.
     * @return the MicrosoftGraphChannel object itself.
     */
    public MicrosoftGraphChannel withEmail(String email) {
        this.email = email;
        return this;
    }

    /**
     * Get the isFavoriteByDefault property: Indicates whether the channel should automatically be marked 'favorite' for
     * all members of the team. Can only be set programmatically with Create team. Default: false.
     *
     * @return the isFavoriteByDefault value.
     */
    public Boolean isFavoriteByDefault() {
        return this.isFavoriteByDefault;
    }

    /**
     * Set the isFavoriteByDefault property: Indicates whether the channel should automatically be marked 'favorite' for
     * all members of the team. Can only be set programmatically with Create team. Default: false.
     *
     * @param isFavoriteByDefault the isFavoriteByDefault value to set.
     * @return the MicrosoftGraphChannel object itself.
     */
    public MicrosoftGraphChannel withIsFavoriteByDefault(Boolean isFavoriteByDefault) {
        this.isFavoriteByDefault = isFavoriteByDefault;
        return this;
    }

    /**
     * Get the membershipType property: The membershipType property.
     *
     * @return the membershipType value.
     */
    public MicrosoftGraphChannelMembershipType membershipType() {
        return this.membershipType;
    }

    /**
     * Set the membershipType property: The membershipType property.
     *
     * @param membershipType the membershipType value to set.
     * @return the MicrosoftGraphChannel object itself.
     */
    public MicrosoftGraphChannel withMembershipType(MicrosoftGraphChannelMembershipType membershipType) {
        this.membershipType = membershipType;
        return this;
    }

    /**
     * Get the webUrl property: A hyperlink that will go to the channel in Microsoft Teams. This is the URL that you get
     * when you right-click a channel in Microsoft Teams and select Get link to channel. This URL should be treated as
     * an opaque blob, and not parsed. Read-only.
     *
     * @return the webUrl value.
     */
    public String webUrl() {
        return this.webUrl;
    }

    /**
     * Set the webUrl property: A hyperlink that will go to the channel in Microsoft Teams. This is the URL that you get
     * when you right-click a channel in Microsoft Teams and select Get link to channel. This URL should be treated as
     * an opaque blob, and not parsed. Read-only.
     *
     * @param webUrl the webUrl value to set.
     * @return the MicrosoftGraphChannel object itself.
     */
    public MicrosoftGraphChannel withWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    /**
     * Get the filesFolder property: driveItem.
     *
     * @return the filesFolder value.
     */
    public MicrosoftGraphDriveItem filesFolder() {
        return this.filesFolder;
    }

    /**
     * Set the filesFolder property: driveItem.
     *
     * @param filesFolder the filesFolder value to set.
     * @return the MicrosoftGraphChannel object itself.
     */
    public MicrosoftGraphChannel withFilesFolder(MicrosoftGraphDriveItem filesFolder) {
        this.filesFolder = filesFolder;
        return this;
    }

    /**
     * Get the members property: A collection of membership records associated with the channel.
     *
     * @return the members value.
     */
    public List<MicrosoftGraphConversationMember> members() {
        return this.members;
    }

    /**
     * Set the members property: A collection of membership records associated with the channel.
     *
     * @param members the members value to set.
     * @return the MicrosoftGraphChannel object itself.
     */
    public MicrosoftGraphChannel withMembers(List<MicrosoftGraphConversationMember> members) {
        this.members = members;
        return this;
    }

    /**
     * Get the messages property: A collection of all the messages in the channel. A navigation property. Nullable.
     *
     * @return the messages value.
     */
    public List<MicrosoftGraphChatMessage> messages() {
        return this.messages;
    }

    /**
     * Set the messages property: A collection of all the messages in the channel. A navigation property. Nullable.
     *
     * @param messages the messages value to set.
     * @return the MicrosoftGraphChannel object itself.
     */
    public MicrosoftGraphChannel withMessages(List<MicrosoftGraphChatMessage> messages) {
        this.messages = messages;
        return this;
    }

    /**
     * Get the tabs property: A collection of all the tabs in the channel. A navigation property.
     *
     * @return the tabs value.
     */
    public List<MicrosoftGraphTeamsTab> tabs() {
        return this.tabs;
    }

    /**
     * Set the tabs property: A collection of all the tabs in the channel. A navigation property.
     *
     * @param tabs the tabs value to set.
     * @return the MicrosoftGraphChannel object itself.
     */
    public MicrosoftGraphChannel withTabs(List<MicrosoftGraphTeamsTab> tabs) {
        this.tabs = tabs;
        return this;
    }

    /**
     * Get the additionalProperties property: channel.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: channel.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphChannel object itself.
     */
    public MicrosoftGraphChannel withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphChannel withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (filesFolder() != null) {
            filesFolder().validate();
        }
        if (members() != null) {
            members().forEach(e -> e.validate());
        }
        if (messages() != null) {
            messages().forEach(e -> e.validate());
        }
        if (tabs() != null) {
            tabs().forEach(e -> e.validate());
        }
    }
}
