// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/** calendarGroup. */
@Fluent
public final class MicrosoftGraphCalendarGroup extends MicrosoftGraphEntity {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphCalendarGroup.class);

    /*
     * Identifies the version of the calendar group. Every time the calendar
     * group is changed, ChangeKey changes as well. This allows Exchange to
     * apply changes to the correct version of the object. Read-only.
     */
    @JsonProperty(value = "changeKey")
    private String changeKey;

    /*
     * The class identifier. Read-only.
     */
    @JsonProperty(value = "classId")
    private UUID classId;

    /*
     * The group name.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * The calendars in the calendar group. Navigation property. Read-only.
     * Nullable.
     */
    @JsonProperty(value = "calendars")
    private List<MicrosoftGraphCalendar> calendars;

    /*
     * calendarGroup
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the changeKey property: Identifies the version of the calendar group. Every time the calendar group is
     * changed, ChangeKey changes as well. This allows Exchange to apply changes to the correct version of the object.
     * Read-only.
     *
     * @return the changeKey value.
     */
    public String changeKey() {
        return this.changeKey;
    }

    /**
     * Set the changeKey property: Identifies the version of the calendar group. Every time the calendar group is
     * changed, ChangeKey changes as well. This allows Exchange to apply changes to the correct version of the object.
     * Read-only.
     *
     * @param changeKey the changeKey value to set.
     * @return the MicrosoftGraphCalendarGroup object itself.
     */
    public MicrosoftGraphCalendarGroup withChangeKey(String changeKey) {
        this.changeKey = changeKey;
        return this;
    }

    /**
     * Get the classId property: The class identifier. Read-only.
     *
     * @return the classId value.
     */
    public UUID classId() {
        return this.classId;
    }

    /**
     * Set the classId property: The class identifier. Read-only.
     *
     * @param classId the classId value to set.
     * @return the MicrosoftGraphCalendarGroup object itself.
     */
    public MicrosoftGraphCalendarGroup withClassId(UUID classId) {
        this.classId = classId;
        return this;
    }

    /**
     * Get the name property: The group name.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The group name.
     *
     * @param name the name value to set.
     * @return the MicrosoftGraphCalendarGroup object itself.
     */
    public MicrosoftGraphCalendarGroup withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the calendars property: The calendars in the calendar group. Navigation property. Read-only. Nullable.
     *
     * @return the calendars value.
     */
    public List<MicrosoftGraphCalendar> calendars() {
        return this.calendars;
    }

    /**
     * Set the calendars property: The calendars in the calendar group. Navigation property. Read-only. Nullable.
     *
     * @param calendars the calendars value to set.
     * @return the MicrosoftGraphCalendarGroup object itself.
     */
    public MicrosoftGraphCalendarGroup withCalendars(List<MicrosoftGraphCalendar> calendars) {
        this.calendars = calendars;
        return this;
    }

    /**
     * Get the additionalProperties property: calendarGroup.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: calendarGroup.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphCalendarGroup object itself.
     */
    public MicrosoftGraphCalendarGroup withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphCalendarGroup withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (calendars() != null) {
            calendars().forEach(e -> e.validate());
        }
    }
}
