// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** alternativeSecurityId. */
@Fluent
public final class MicrosoftGraphAlternativeSecurityId {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphAlternativeSecurityId.class);

    /*
     * For internal use only
     */
    @JsonProperty(value = "identityProvider")
    private String identityProvider;

    /*
     * For internal use only
     */
    @JsonProperty(value = "key")
    private Base64Url key;

    /*
     * For internal use only
     */
    @JsonProperty(value = "type")
    private Integer type;

    /*
     * alternativeSecurityId
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the identityProvider property: For internal use only.
     *
     * @return the identityProvider value.
     */
    public String identityProvider() {
        return this.identityProvider;
    }

    /**
     * Set the identityProvider property: For internal use only.
     *
     * @param identityProvider the identityProvider value to set.
     * @return the MicrosoftGraphAlternativeSecurityId object itself.
     */
    public MicrosoftGraphAlternativeSecurityId withIdentityProvider(String identityProvider) {
        this.identityProvider = identityProvider;
        return this;
    }

    /**
     * Get the key property: For internal use only.
     *
     * @return the key value.
     */
    public byte[] key() {
        if (this.key == null) {
            return null;
        }
        return this.key.decodedBytes();
    }

    /**
     * Set the key property: For internal use only.
     *
     * @param key the key value to set.
     * @return the MicrosoftGraphAlternativeSecurityId object itself.
     */
    public MicrosoftGraphAlternativeSecurityId withKey(byte[] key) {
        if (key == null) {
            this.key = null;
        } else {
            this.key = Base64Url.encode(CoreUtils.clone(key));
        }
        return this;
    }

    /**
     * Get the type property: For internal use only.
     *
     * @return the type value.
     */
    public Integer type() {
        return this.type;
    }

    /**
     * Set the type property: For internal use only.
     *
     * @param type the type value to set.
     * @return the MicrosoftGraphAlternativeSecurityId object itself.
     */
    public MicrosoftGraphAlternativeSecurityId withType(Integer type) {
        this.type = type;
        return this;
    }

    /**
     * Get the additionalProperties property: alternativeSecurityId.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: alternativeSecurityId.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphAlternativeSecurityId object itself.
     */
    public MicrosoftGraphAlternativeSecurityId withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
