// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Classic Administrator properties. */
@Fluent
public final class ClassicAdministratorProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ClassicAdministratorProperties.class);

    /*
     * The email address of the administrator.
     */
    @JsonProperty(value = "emailAddress")
    private String emailAddress;

    /*
     * The role of the administrator.
     */
    @JsonProperty(value = "role")
    private String role;

    /**
     * Get the emailAddress property: The email address of the administrator.
     *
     * @return the emailAddress value.
     */
    public String emailAddress() {
        return this.emailAddress;
    }

    /**
     * Set the emailAddress property: The email address of the administrator.
     *
     * @param emailAddress the emailAddress value to set.
     * @return the ClassicAdministratorProperties object itself.
     */
    public ClassicAdministratorProperties withEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    /**
     * Get the role property: The role of the administrator.
     *
     * @return the role value.
     */
    public String role() {
        return this.role;
    }

    /**
     * Set the role property: The role of the administrator.
     *
     * @param role the role value to set.
     * @return the ClassicAdministratorProperties object itself.
     */
    public ClassicAdministratorProperties withRole(String role) {
        this.role = role;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
