// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.authorization.fluent.models.Get5ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphLinkedResourceInner;
import com.azure.resourcemanager.authorization.fluent.models.UsersTodoListsTasksOrderby;
import com.azure.resourcemanager.authorization.fluent.models.UsersTodoListsTasksSelect;
import java.util.List;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in UsersTodoListsTasksClient. */
public interface UsersTodoListsTasksClient {
    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoListsTasksOrderby> orderby,
        List<String> select,
        List<String> expand);

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(
        String userId, String todoTaskListId, String todoTaskId);

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphExtensionInner> listExtensions(String userId, String todoTaskListId, String todoTaskId);

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphExtensionInner> listExtensions(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoListsTasksOrderby> orderby,
        List<String> select,
        List<String> expand,
        Context context);

    /**
     * Create new navigation property to extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphExtensionInner>> createExtensionsWithResponseAsync(
        String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphExtensionInner body);

    /**
     * Create new navigation property to extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphExtensionInner> createExtensionsAsync(
        String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphExtensionInner body);

    /**
     * Create new navigation property to extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphExtensionInner createExtensions(
        String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphExtensionInner body);

    /**
     * Create new navigation property to extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extension.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphExtensionInner> createExtensionsWithResponse(
        String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphExtensionInner body, Context context);

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphExtensionInner>> getExtensionsWithResponseAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String extensionId,
        List<String> select,
        List<Get5ItemsItem> expand);

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphExtensionInner> getExtensionsAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String extensionId,
        List<String> select,
        List<Get5ItemsItem> expand);

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphExtensionInner> getExtensionsAsync(
        String userId, String todoTaskListId, String todoTaskId, String extensionId);

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphExtensionInner getExtensions(
        String userId, String todoTaskListId, String todoTaskId, String extensionId);

    /**
     * Get extensions from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return extensions from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphExtensionInner> getExtensionsWithResponse(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String extensionId,
        List<String> select,
        List<Get5ItemsItem> expand,
        Context context);

    /**
     * Update the navigation property extensions in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> updateExtensionsWithResponseAsync(
        String userId, String todoTaskListId, String todoTaskId, String extensionId, MicrosoftGraphExtensionInner body);

    /**
     * Update the navigation property extensions in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> updateExtensionsAsync(
        String userId, String todoTaskListId, String todoTaskId, String extensionId, MicrosoftGraphExtensionInner body);

    /**
     * Update the navigation property extensions in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void updateExtensions(
        String userId, String todoTaskListId, String todoTaskId, String extensionId, MicrosoftGraphExtensionInner body);

    /**
     * Update the navigation property extensions in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updateExtensionsWithResponse(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String extensionId,
        MicrosoftGraphExtensionInner body,
        Context context);

    /**
     * Delete navigation property extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteExtensionsWithResponseAsync(
        String userId, String todoTaskListId, String todoTaskId, String extensionId, String ifMatch);

    /**
     * Delete navigation property extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteExtensionsAsync(
        String userId, String todoTaskListId, String todoTaskId, String extensionId, String ifMatch);

    /**
     * Delete navigation property extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteExtensionsAsync(String userId, String todoTaskListId, String todoTaskId, String extensionId);

    /**
     * Delete navigation property extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteExtensions(String userId, String todoTaskListId, String todoTaskId, String extensionId);

    /**
     * Delete navigation property extensions for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param extensionId key: id of extension.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteExtensionsWithResponse(
        String userId, String todoTaskListId, String todoTaskId, String extensionId, String ifMatch, Context context);

    /**
     * Get linkedResources from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResources from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphLinkedResourceInner> listLinkedResourcesAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoListsTasksOrderby> orderby,
        List<UsersTodoListsTasksSelect> select,
        List<String> expand);

    /**
     * Get linkedResources from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResources from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphLinkedResourceInner> listLinkedResourcesAsync(
        String userId, String todoTaskListId, String todoTaskId);

    /**
     * Get linkedResources from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResources from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphLinkedResourceInner> listLinkedResources(
        String userId, String todoTaskListId, String todoTaskId);

    /**
     * Get linkedResources from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResources from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphLinkedResourceInner> listLinkedResources(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersTodoListsTasksOrderby> orderby,
        List<UsersTodoListsTasksSelect> select,
        List<String> expand,
        Context context);

    /**
     * Create new navigation property to linkedResources for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphLinkedResourceInner>> createLinkedResourcesWithResponseAsync(
        String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphLinkedResourceInner body);

    /**
     * Create new navigation property to linkedResources for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphLinkedResourceInner> createLinkedResourcesAsync(
        String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphLinkedResourceInner body);

    /**
     * Create new navigation property to linkedResources for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphLinkedResourceInner createLinkedResources(
        String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphLinkedResourceInner body);

    /**
     * Create new navigation property to linkedResources for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphLinkedResourceInner> createLinkedResourcesWithResponse(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        MicrosoftGraphLinkedResourceInner body,
        Context context);

    /**
     * Get linkedResources from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResources from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphLinkedResourceInner>> getLinkedResourcesWithResponseAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String linkedResourceId,
        List<UsersTodoListsTasksSelect> select,
        List<String> expand);

    /**
     * Get linkedResources from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResources from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphLinkedResourceInner> getLinkedResourcesAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String linkedResourceId,
        List<UsersTodoListsTasksSelect> select,
        List<String> expand);

    /**
     * Get linkedResources from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResources from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphLinkedResourceInner> getLinkedResourcesAsync(
        String userId, String todoTaskListId, String todoTaskId, String linkedResourceId);

    /**
     * Get linkedResources from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResources from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphLinkedResourceInner getLinkedResources(
        String userId, String todoTaskListId, String todoTaskId, String linkedResourceId);

    /**
     * Get linkedResources from users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return linkedResources from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphLinkedResourceInner> getLinkedResourcesWithResponse(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String linkedResourceId,
        List<UsersTodoListsTasksSelect> select,
        List<String> expand,
        Context context);

    /**
     * Update the navigation property linkedResources in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> updateLinkedResourcesWithResponseAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String linkedResourceId,
        MicrosoftGraphLinkedResourceInner body);

    /**
     * Update the navigation property linkedResources in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> updateLinkedResourcesAsync(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String linkedResourceId,
        MicrosoftGraphLinkedResourceInner body);

    /**
     * Update the navigation property linkedResources in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void updateLinkedResources(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String linkedResourceId,
        MicrosoftGraphLinkedResourceInner body);

    /**
     * Update the navigation property linkedResources in users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updateLinkedResourcesWithResponse(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String linkedResourceId,
        MicrosoftGraphLinkedResourceInner body,
        Context context);

    /**
     * Delete navigation property linkedResources for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteLinkedResourcesWithResponseAsync(
        String userId, String todoTaskListId, String todoTaskId, String linkedResourceId, String ifMatch);

    /**
     * Delete navigation property linkedResources for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteLinkedResourcesAsync(
        String userId, String todoTaskListId, String todoTaskId, String linkedResourceId, String ifMatch);

    /**
     * Delete navigation property linkedResources for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteLinkedResourcesAsync(
        String userId, String todoTaskListId, String todoTaskId, String linkedResourceId);

    /**
     * Delete navigation property linkedResources for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteLinkedResources(String userId, String todoTaskListId, String todoTaskId, String linkedResourceId);

    /**
     * Delete navigation property linkedResources for users.
     *
     * @param userId key: id of user.
     * @param todoTaskListId key: id of todoTaskList.
     * @param todoTaskId key: id of todoTask.
     * @param linkedResourceId key: id of linkedResource.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteLinkedResourcesWithResponse(
        String userId,
        String todoTaskListId,
        String todoTaskId,
        String linkedResourceId,
        String ifMatch,
        Context context);
}
