// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOutlookCategoryInner;
import com.azure.resourcemanager.authorization.fluent.models.UsersOutlookOrderby;
import com.azure.resourcemanager.authorization.fluent.models.UsersOutlookSelect;
import java.util.List;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in UsersOutlooksClient. */
public interface UsersOutlooksClient {
    /**
     * Get masterCategories from users.
     *
     * @param userId key: id of user.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return masterCategories from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphOutlookCategoryInner> listMasterCategoriesAsync(
        String userId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersOutlookOrderby> orderby,
        List<UsersOutlookSelect> select,
        List<String> expand);

    /**
     * Get masterCategories from users.
     *
     * @param userId key: id of user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return masterCategories from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphOutlookCategoryInner> listMasterCategoriesAsync(String userId);

    /**
     * Get masterCategories from users.
     *
     * @param userId key: id of user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return masterCategories from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphOutlookCategoryInner> listMasterCategories(String userId);

    /**
     * Get masterCategories from users.
     *
     * @param userId key: id of user.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return masterCategories from users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphOutlookCategoryInner> listMasterCategories(
        String userId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<UsersOutlookOrderby> orderby,
        List<UsersOutlookSelect> select,
        List<String> expand,
        Context context);

    /**
     * Create new navigation property to masterCategories for users.
     *
     * @param userId key: id of user.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return outlookCategory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphOutlookCategoryInner>> createMasterCategoriesWithResponseAsync(
        String userId, MicrosoftGraphOutlookCategoryInner body);

    /**
     * Create new navigation property to masterCategories for users.
     *
     * @param userId key: id of user.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return outlookCategory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphOutlookCategoryInner> createMasterCategoriesAsync(
        String userId, MicrosoftGraphOutlookCategoryInner body);

    /**
     * Create new navigation property to masterCategories for users.
     *
     * @param userId key: id of user.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return outlookCategory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphOutlookCategoryInner createMasterCategories(String userId, MicrosoftGraphOutlookCategoryInner body);

    /**
     * Create new navigation property to masterCategories for users.
     *
     * @param userId key: id of user.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return outlookCategory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphOutlookCategoryInner> createMasterCategoriesWithResponse(
        String userId, MicrosoftGraphOutlookCategoryInner body, Context context);

    /**
     * Get masterCategories from users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return masterCategories from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphOutlookCategoryInner>> getMasterCategoriesWithResponseAsync(
        String userId, String outlookCategoryId, List<UsersOutlookSelect> select, List<String> expand);

    /**
     * Get masterCategories from users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return masterCategories from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphOutlookCategoryInner> getMasterCategoriesAsync(
        String userId, String outlookCategoryId, List<UsersOutlookSelect> select, List<String> expand);

    /**
     * Get masterCategories from users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return masterCategories from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphOutlookCategoryInner> getMasterCategoriesAsync(String userId, String outlookCategoryId);

    /**
     * Get masterCategories from users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return masterCategories from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphOutlookCategoryInner getMasterCategories(String userId, String outlookCategoryId);

    /**
     * Get masterCategories from users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return masterCategories from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphOutlookCategoryInner> getMasterCategoriesWithResponse(
        String userId, String outlookCategoryId, List<UsersOutlookSelect> select, List<String> expand, Context context);

    /**
     * Update the navigation property masterCategories in users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> updateMasterCategoriesWithResponseAsync(
        String userId, String outlookCategoryId, MicrosoftGraphOutlookCategoryInner body);

    /**
     * Update the navigation property masterCategories in users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> updateMasterCategoriesAsync(
        String userId, String outlookCategoryId, MicrosoftGraphOutlookCategoryInner body);

    /**
     * Update the navigation property masterCategories in users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void updateMasterCategories(String userId, String outlookCategoryId, MicrosoftGraphOutlookCategoryInner body);

    /**
     * Update the navigation property masterCategories in users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updateMasterCategoriesWithResponse(
        String userId, String outlookCategoryId, MicrosoftGraphOutlookCategoryInner body, Context context);

    /**
     * Delete navigation property masterCategories for users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteMasterCategoriesWithResponseAsync(
        String userId, String outlookCategoryId, String ifMatch);

    /**
     * Delete navigation property masterCategories for users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteMasterCategoriesAsync(String userId, String outlookCategoryId, String ifMatch);

    /**
     * Delete navigation property masterCategories for users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteMasterCategoriesAsync(String userId, String outlookCategoryId);

    /**
     * Delete navigation property masterCategories for users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteMasterCategories(String userId, String outlookCategoryId);

    /**
     * Delete navigation property masterCategories for users.
     *
     * @param userId key: id of user.
     * @param outlookCategoryId key: id of outlookCategory.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteMasterCategoriesWithResponse(
        String userId, String outlookCategoryId, String ifMatch, Context context);
}
