// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.authorization.fluent.models.RoleAssignmentMetricsResultInner;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in RoleAssignmentMetricsClient. */
public interface RoleAssignmentMetricsClient {
    /**
     * Get role assignment usage metrics for a subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment usage metrics for a subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RoleAssignmentMetricsResultInner>> getMetricsForSubscriptionWithResponseAsync();

    /**
     * Get role assignment usage metrics for a subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment usage metrics for a subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RoleAssignmentMetricsResultInner> getMetricsForSubscriptionAsync();

    /**
     * Get role assignment usage metrics for a subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment usage metrics for a subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RoleAssignmentMetricsResultInner getMetricsForSubscription();

    /**
     * Get role assignment usage metrics for a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role assignment usage metrics for a subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RoleAssignmentMetricsResultInner> getMetricsForSubscriptionWithResponse(Context context);
}
