// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.authorization.fluent.models.GroupLifecyclePoliciesAddGroupRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.GroupLifecyclePoliciesRemoveGroupRequestBody;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in GroupLifecyclePoliciesClient. */
public interface GroupLifecyclePoliciesClient {
    /**
     * Invoke action addGroup.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Boolean>> addGroupWithResponseAsync(
        String groupLifecyclePolicyId, GroupLifecyclePoliciesAddGroupRequestBody body);

    /**
     * Invoke action addGroup.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Boolean> addGroupAsync(String groupLifecyclePolicyId, GroupLifecyclePoliciesAddGroupRequestBody body);

    /**
     * Invoke action addGroup.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    boolean addGroup(String groupLifecyclePolicyId, GroupLifecyclePoliciesAddGroupRequestBody body);

    /**
     * Invoke action addGroup.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Boolean> addGroupWithResponse(
        String groupLifecyclePolicyId, GroupLifecyclePoliciesAddGroupRequestBody body, Context context);

    /**
     * Invoke action removeGroup.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Boolean>> removeGroupWithResponseAsync(
        String groupLifecyclePolicyId, GroupLifecyclePoliciesRemoveGroupRequestBody body);

    /**
     * Invoke action removeGroup.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Boolean> removeGroupAsync(String groupLifecyclePolicyId, GroupLifecyclePoliciesRemoveGroupRequestBody body);

    /**
     * Invoke action removeGroup.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    boolean removeGroup(String groupLifecyclePolicyId, GroupLifecyclePoliciesRemoveGroupRequestBody body);

    /**
     * Invoke action removeGroup.
     *
     * @param groupLifecyclePolicyId key: id of groupLifecyclePolicy.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Boolean> removeGroupWithResponse(
        String groupLifecyclePolicyId, GroupLifecyclePoliciesRemoveGroupRequestBody body, Context context);
}
