/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.KeyVaultReferenceWithStatus;
import com.azure.resourcemanager.appservice.models.StorageMountType;
import java.io.IOException;

public final class StorageMount
implements JsonSerializable<StorageMount> {
    private String name;
    private StorageMountType type;
    private String source;
    private String destinationPath;
    private KeyVaultReferenceWithStatus credentialsKeyVaultReference;

    public String name() {
        return this.name;
    }

    public StorageMount withName(String name) {
        this.name = name;
        return this;
    }

    public StorageMountType type() {
        return this.type;
    }

    public StorageMount withType(StorageMountType type) {
        this.type = type;
        return this;
    }

    public String source() {
        return this.source;
    }

    public StorageMount withSource(String source) {
        this.source = source;
        return this;
    }

    public String destinationPath() {
        return this.destinationPath;
    }

    public StorageMount withDestinationPath(String destinationPath) {
        this.destinationPath = destinationPath;
        return this;
    }

    public KeyVaultReferenceWithStatus credentialsKeyVaultReference() {
        return this.credentialsKeyVaultReference;
    }

    public StorageMount withCredentialsKeyVaultReference(KeyVaultReferenceWithStatus credentialsKeyVaultReference) {
        this.credentialsKeyVaultReference = credentialsKeyVaultReference;
        return this;
    }

    public void validate() {
        if (this.credentialsKeyVaultReference() != null) {
            this.credentialsKeyVaultReference().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("source", this.source);
        jsonWriter.writeStringField("destinationPath", this.destinationPath);
        jsonWriter.writeJsonField("credentialsKeyVaultReference", (JsonSerializable)this.credentialsKeyVaultReference);
        return jsonWriter.writeEndObject();
    }

    public static StorageMount fromJson(JsonReader jsonReader) throws IOException {
        return (StorageMount)jsonReader.readObject(reader -> {
            StorageMount deserializedStorageMount = new StorageMount();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedStorageMount.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedStorageMount.type = StorageMountType.fromString(reader.getString());
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedStorageMount.source = reader.getString();
                    continue;
                }
                if ("destinationPath".equals(fieldName)) {
                    deserializedStorageMount.destinationPath = reader.getString();
                    continue;
                }
                if ("credentialsKeyVaultReference".equals(fieldName)) {
                    deserializedStorageMount.credentialsKeyVaultReference = KeyVaultReferenceWithStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageMount;
        });
    }
}

