/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.StackMinorVersion;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class StackMajorVersion
implements JsonSerializable<StackMajorVersion> {
    private String displayVersion;
    private String runtimeVersion;
    private Boolean isDefault;
    private List<StackMinorVersion> minorVersions;
    private Boolean applicationInsights;
    private Boolean isPreview;
    private Boolean isDeprecated;
    private Boolean isHidden;
    private Map<String, Object> appSettingsDictionary;
    private Map<String, Object> siteConfigPropertiesDictionary;

    public String displayVersion() {
        return this.displayVersion;
    }

    public StackMajorVersion withDisplayVersion(String displayVersion) {
        this.displayVersion = displayVersion;
        return this;
    }

    public String runtimeVersion() {
        return this.runtimeVersion;
    }

    public StackMajorVersion withRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return this;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public StackMajorVersion withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    public List<StackMinorVersion> minorVersions() {
        return this.minorVersions;
    }

    public StackMajorVersion withMinorVersions(List<StackMinorVersion> minorVersions) {
        this.minorVersions = minorVersions;
        return this;
    }

    public Boolean applicationInsights() {
        return this.applicationInsights;
    }

    public StackMajorVersion withApplicationInsights(Boolean applicationInsights) {
        this.applicationInsights = applicationInsights;
        return this;
    }

    public Boolean isPreview() {
        return this.isPreview;
    }

    public StackMajorVersion withIsPreview(Boolean isPreview) {
        this.isPreview = isPreview;
        return this;
    }

    public Boolean isDeprecated() {
        return this.isDeprecated;
    }

    public StackMajorVersion withIsDeprecated(Boolean isDeprecated) {
        this.isDeprecated = isDeprecated;
        return this;
    }

    public Boolean isHidden() {
        return this.isHidden;
    }

    public StackMajorVersion withIsHidden(Boolean isHidden) {
        this.isHidden = isHidden;
        return this;
    }

    public Map<String, Object> appSettingsDictionary() {
        return this.appSettingsDictionary;
    }

    public StackMajorVersion withAppSettingsDictionary(Map<String, Object> appSettingsDictionary) {
        this.appSettingsDictionary = appSettingsDictionary;
        return this;
    }

    public Map<String, Object> siteConfigPropertiesDictionary() {
        return this.siteConfigPropertiesDictionary;
    }

    public StackMajorVersion withSiteConfigPropertiesDictionary(Map<String, Object> siteConfigPropertiesDictionary) {
        this.siteConfigPropertiesDictionary = siteConfigPropertiesDictionary;
        return this;
    }

    public void validate() {
        if (this.minorVersions() != null) {
            this.minorVersions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayVersion", this.displayVersion);
        jsonWriter.writeStringField("runtimeVersion", this.runtimeVersion);
        jsonWriter.writeBooleanField("isDefault", this.isDefault);
        jsonWriter.writeArrayField("minorVersions", this.minorVersions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("applicationInsights", this.applicationInsights);
        jsonWriter.writeBooleanField("isPreview", this.isPreview);
        jsonWriter.writeBooleanField("isDeprecated", this.isDeprecated);
        jsonWriter.writeBooleanField("isHidden", this.isHidden);
        jsonWriter.writeMapField("appSettingsDictionary", this.appSettingsDictionary, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeMapField("siteConfigPropertiesDictionary", this.siteConfigPropertiesDictionary, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    public static StackMajorVersion fromJson(JsonReader jsonReader) throws IOException {
        return (StackMajorVersion)jsonReader.readObject(reader -> {
            StackMajorVersion deserializedStackMajorVersion = new StackMajorVersion();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayVersion".equals(fieldName)) {
                    deserializedStackMajorVersion.displayVersion = reader.getString();
                    continue;
                }
                if ("runtimeVersion".equals(fieldName)) {
                    deserializedStackMajorVersion.runtimeVersion = reader.getString();
                    continue;
                }
                if ("isDefault".equals(fieldName)) {
                    deserializedStackMajorVersion.isDefault = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("minorVersions".equals(fieldName)) {
                    List minorVersions;
                    deserializedStackMajorVersion.minorVersions = minorVersions = reader.readArray(reader1 -> StackMinorVersion.fromJson(reader1));
                    continue;
                }
                if ("applicationInsights".equals(fieldName)) {
                    deserializedStackMajorVersion.applicationInsights = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isPreview".equals(fieldName)) {
                    deserializedStackMajorVersion.isPreview = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isDeprecated".equals(fieldName)) {
                    deserializedStackMajorVersion.isDeprecated = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isHidden".equals(fieldName)) {
                    deserializedStackMajorVersion.isHidden = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("appSettingsDictionary".equals(fieldName)) {
                    Map appSettingsDictionary;
                    deserializedStackMajorVersion.appSettingsDictionary = appSettingsDictionary = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("siteConfigPropertiesDictionary".equals(fieldName)) {
                    Map siteConfigPropertiesDictionary;
                    deserializedStackMajorVersion.siteConfigPropertiesDictionary = siteConfigPropertiesDictionary = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStackMajorVersion;
        });
    }
}

