/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.SnapshotInner;
import java.io.IOException;
import java.util.List;

public final class SnapshotCollection
implements JsonSerializable<SnapshotCollection> {
    private List<SnapshotInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(SnapshotCollection.class);

    public List<SnapshotInner> value() {
        return this.value;
    }

    public SnapshotCollection withValue(List<SnapshotInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model SnapshotCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SnapshotCollection fromJson(JsonReader jsonReader) throws IOException {
        return (SnapshotCollection)jsonReader.readObject(reader -> {
            SnapshotCollection deserializedSnapshotCollection = new SnapshotCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSnapshotCollection.value = value = reader.readArray(reader1 -> SnapshotInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedSnapshotCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSnapshotCollection;
        });
    }
}

