/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.KeyVaultReferenceWithStatus;
import com.azure.resourcemanager.appservice.models.RegistryAdapterType;
import java.io.IOException;

public final class RegistryAdapter
implements JsonSerializable<RegistryAdapter> {
    private String registryKey;
    private RegistryAdapterType type;
    private KeyVaultReferenceWithStatus keyVaultSecretReference;

    public String registryKey() {
        return this.registryKey;
    }

    public RegistryAdapter withRegistryKey(String registryKey) {
        this.registryKey = registryKey;
        return this;
    }

    public RegistryAdapterType type() {
        return this.type;
    }

    public RegistryAdapter withType(RegistryAdapterType type) {
        this.type = type;
        return this;
    }

    public KeyVaultReferenceWithStatus keyVaultSecretReference() {
        return this.keyVaultSecretReference;
    }

    public RegistryAdapter withKeyVaultSecretReference(KeyVaultReferenceWithStatus keyVaultSecretReference) {
        this.keyVaultSecretReference = keyVaultSecretReference;
        return this;
    }

    public void validate() {
        if (this.keyVaultSecretReference() != null) {
            this.keyVaultSecretReference().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("registryKey", this.registryKey);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("keyVaultSecretReference", (JsonSerializable)this.keyVaultSecretReference);
        return jsonWriter.writeEndObject();
    }

    public static RegistryAdapter fromJson(JsonReader jsonReader) throws IOException {
        return (RegistryAdapter)jsonReader.readObject(reader -> {
            RegistryAdapter deserializedRegistryAdapter = new RegistryAdapter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("registryKey".equals(fieldName)) {
                    deserializedRegistryAdapter.registryKey = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRegistryAdapter.type = RegistryAdapterType.fromString(reader.getString());
                    continue;
                }
                if ("keyVaultSecretReference".equals(fieldName)) {
                    deserializedRegistryAdapter.keyVaultSecretReference = KeyVaultReferenceWithStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRegistryAdapter;
        });
    }
}

