/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.PrivateAccessSubnet;
import java.io.IOException;
import java.util.List;

public final class PrivateAccessVirtualNetwork
implements JsonSerializable<PrivateAccessVirtualNetwork> {
    private String name;
    private Integer key;
    private String resourceId;
    private List<PrivateAccessSubnet> subnets;

    public String name() {
        return this.name;
    }

    public PrivateAccessVirtualNetwork withName(String name) {
        this.name = name;
        return this;
    }

    public Integer key() {
        return this.key;
    }

    public PrivateAccessVirtualNetwork withKey(Integer key) {
        this.key = key;
        return this;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public PrivateAccessVirtualNetwork withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public List<PrivateAccessSubnet> subnets() {
        return this.subnets;
    }

    public PrivateAccessVirtualNetwork withSubnets(List<PrivateAccessSubnet> subnets) {
        this.subnets = subnets;
        return this;
    }

    public void validate() {
        if (this.subnets() != null) {
            this.subnets().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeNumberField("key", (Number)this.key);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeArrayField("subnets", this.subnets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static PrivateAccessVirtualNetwork fromJson(JsonReader jsonReader) throws IOException {
        return (PrivateAccessVirtualNetwork)jsonReader.readObject(reader -> {
            PrivateAccessVirtualNetwork deserializedPrivateAccessVirtualNetwork = new PrivateAccessVirtualNetwork();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedPrivateAccessVirtualNetwork.name = reader.getString();
                    continue;
                }
                if ("key".equals(fieldName)) {
                    deserializedPrivateAccessVirtualNetwork.key = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedPrivateAccessVirtualNetwork.resourceId = reader.getString();
                    continue;
                }
                if ("subnets".equals(fieldName)) {
                    List subnets;
                    deserializedPrivateAccessVirtualNetwork.subnets = subnets = reader.readArray(reader1 -> PrivateAccessSubnet.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateAccessVirtualNetwork;
        });
    }
}

