/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public class MSDeployCore
implements JsonSerializable<MSDeployCore> {
    private String packageUri;
    private String connectionString;
    private String dbType;
    private String setParametersXmlFileUri;
    private Map<String, String> setParameters;
    private Boolean skipAppData;
    private Boolean appOffline;

    public String packageUri() {
        return this.packageUri;
    }

    public MSDeployCore withPackageUri(String packageUri) {
        this.packageUri = packageUri;
        return this;
    }

    public String connectionString() {
        return this.connectionString;
    }

    public MSDeployCore withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public String dbType() {
        return this.dbType;
    }

    public MSDeployCore withDbType(String dbType) {
        this.dbType = dbType;
        return this;
    }

    public String setParametersXmlFileUri() {
        return this.setParametersXmlFileUri;
    }

    public MSDeployCore withSetParametersXmlFileUri(String setParametersXmlFileUri) {
        this.setParametersXmlFileUri = setParametersXmlFileUri;
        return this;
    }

    public Map<String, String> setParameters() {
        return this.setParameters;
    }

    public MSDeployCore withSetParameters(Map<String, String> setParameters) {
        this.setParameters = setParameters;
        return this;
    }

    public Boolean skipAppData() {
        return this.skipAppData;
    }

    public MSDeployCore withSkipAppData(Boolean skipAppData) {
        this.skipAppData = skipAppData;
        return this;
    }

    public Boolean appOffline() {
        return this.appOffline;
    }

    public MSDeployCore withAppOffline(Boolean appOffline) {
        this.appOffline = appOffline;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("packageUri", this.packageUri);
        jsonWriter.writeStringField("connectionString", this.connectionString);
        jsonWriter.writeStringField("dbType", this.dbType);
        jsonWriter.writeStringField("setParametersXmlFileUri", this.setParametersXmlFileUri);
        jsonWriter.writeMapField("setParameters", this.setParameters, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("skipAppData", this.skipAppData);
        jsonWriter.writeBooleanField("appOffline", this.appOffline);
        return jsonWriter.writeEndObject();
    }

    public static MSDeployCore fromJson(JsonReader jsonReader) throws IOException {
        return (MSDeployCore)jsonReader.readObject(reader -> {
            MSDeployCore deserializedMSDeployCore = new MSDeployCore();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("packageUri".equals(fieldName)) {
                    deserializedMSDeployCore.packageUri = reader.getString();
                    continue;
                }
                if ("connectionString".equals(fieldName)) {
                    deserializedMSDeployCore.connectionString = reader.getString();
                    continue;
                }
                if ("dbType".equals(fieldName)) {
                    deserializedMSDeployCore.dbType = reader.getString();
                    continue;
                }
                if ("setParametersXmlFileUri".equals(fieldName)) {
                    deserializedMSDeployCore.setParametersXmlFileUri = reader.getString();
                    continue;
                }
                if ("setParameters".equals(fieldName)) {
                    Map setParameters;
                    deserializedMSDeployCore.setParameters = setParameters = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("skipAppData".equals(fieldName)) {
                    deserializedMSDeployCore.skipAppData = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("appOffline".equals(fieldName)) {
                    deserializedMSDeployCore.appOffline = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMSDeployCore;
        });
    }
}

