/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.KubeEnvironmentInner;
import java.io.IOException;
import java.util.List;

public final class KubeEnvironmentCollection
implements JsonSerializable<KubeEnvironmentCollection> {
    private List<KubeEnvironmentInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(KubeEnvironmentCollection.class);

    public List<KubeEnvironmentInner> value() {
        return this.value;
    }

    public KubeEnvironmentCollection withValue(List<KubeEnvironmentInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model KubeEnvironmentCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static KubeEnvironmentCollection fromJson(JsonReader jsonReader) throws IOException {
        return (KubeEnvironmentCollection)jsonReader.readObject(reader -> {
            KubeEnvironmentCollection deserializedKubeEnvironmentCollection = new KubeEnvironmentCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedKubeEnvironmentCollection.value = value = reader.readArray(reader1 -> KubeEnvironmentInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedKubeEnvironmentCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKubeEnvironmentCollection;
        });
    }
}

