/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.AzureBlobStorageHttpLogsConfig;
import com.azure.resourcemanager.appservice.models.FileSystemHttpLogsConfig;
import java.io.IOException;

public final class HttpLogsConfig
implements JsonSerializable<HttpLogsConfig> {
    private FileSystemHttpLogsConfig fileSystem;
    private AzureBlobStorageHttpLogsConfig azureBlobStorage;

    public FileSystemHttpLogsConfig fileSystem() {
        return this.fileSystem;
    }

    public HttpLogsConfig withFileSystem(FileSystemHttpLogsConfig fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    public AzureBlobStorageHttpLogsConfig azureBlobStorage() {
        return this.azureBlobStorage;
    }

    public HttpLogsConfig withAzureBlobStorage(AzureBlobStorageHttpLogsConfig azureBlobStorage) {
        this.azureBlobStorage = azureBlobStorage;
        return this;
    }

    public void validate() {
        if (this.fileSystem() != null) {
            this.fileSystem().validate();
        }
        if (this.azureBlobStorage() != null) {
            this.azureBlobStorage().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("fileSystem", (JsonSerializable)this.fileSystem);
        jsonWriter.writeJsonField("azureBlobStorage", (JsonSerializable)this.azureBlobStorage);
        return jsonWriter.writeEndObject();
    }

    public static HttpLogsConfig fromJson(JsonReader jsonReader) throws IOException {
        return (HttpLogsConfig)jsonReader.readObject(reader -> {
            HttpLogsConfig deserializedHttpLogsConfig = new HttpLogsConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fileSystem".equals(fieldName)) {
                    deserializedHttpLogsConfig.fileSystem = FileSystemHttpLogsConfig.fromJson(reader);
                    continue;
                }
                if ("azureBlobStorage".equals(fieldName)) {
                    deserializedHttpLogsConfig.azureBlobStorage = AzureBlobStorageHttpLogsConfig.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHttpLogsConfig;
        });
    }
}

