/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.AppRegistration;
import com.azure.resourcemanager.appservice.models.LoginScopes;
import java.io.IOException;

public final class Facebook
implements JsonSerializable<Facebook> {
    private Boolean enabled;
    private AppRegistration registration;
    private String graphApiVersion;
    private LoginScopes login;

    public Boolean enabled() {
        return this.enabled;
    }

    public Facebook withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public AppRegistration registration() {
        return this.registration;
    }

    public Facebook withRegistration(AppRegistration registration) {
        this.registration = registration;
        return this;
    }

    public String graphApiVersion() {
        return this.graphApiVersion;
    }

    public Facebook withGraphApiVersion(String graphApiVersion) {
        this.graphApiVersion = graphApiVersion;
        return this;
    }

    public LoginScopes login() {
        return this.login;
    }

    public Facebook withLogin(LoginScopes login) {
        this.login = login;
        return this;
    }

    public void validate() {
        if (this.registration() != null) {
            this.registration().validate();
        }
        if (this.login() != null) {
            this.login().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeJsonField("registration", (JsonSerializable)this.registration);
        jsonWriter.writeStringField("graphApiVersion", this.graphApiVersion);
        jsonWriter.writeJsonField("login", (JsonSerializable)this.login);
        return jsonWriter.writeEndObject();
    }

    public static Facebook fromJson(JsonReader jsonReader) throws IOException {
        return (Facebook)jsonReader.readObject(reader -> {
            Facebook deserializedFacebook = new Facebook();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedFacebook.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("registration".equals(fieldName)) {
                    deserializedFacebook.registration = AppRegistration.fromJson(reader);
                    continue;
                }
                if ("graphApiVersion".equals(fieldName)) {
                    deserializedFacebook.graphApiVersion = reader.getString();
                    continue;
                }
                if ("login".equals(fieldName)) {
                    deserializedFacebook.login = LoginScopes.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFacebook;
        });
    }
}

