/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.DeploymentInner;
import java.io.IOException;
import java.util.List;

public final class DeploymentCollection
implements JsonSerializable<DeploymentCollection> {
    private List<DeploymentInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(DeploymentCollection.class);

    public List<DeploymentInner> value() {
        return this.value;
    }

    public DeploymentCollection withValue(List<DeploymentInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model DeploymentCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DeploymentCollection fromJson(JsonReader jsonReader) throws IOException {
        return (DeploymentCollection)jsonReader.readObject(reader -> {
            DeploymentCollection deserializedDeploymentCollection = new DeploymentCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedDeploymentCollection.value = value = reader.readArray(reader1 -> DeploymentInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedDeploymentCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentCollection;
        });
    }
}

