/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.AppleRegistration;
import com.azure.resourcemanager.appservice.models.LoginScopes;
import java.io.IOException;

public final class Apple
implements JsonSerializable<Apple> {
    private Boolean enabled;
    private AppleRegistration registration;
    private LoginScopes login;

    public Boolean enabled() {
        return this.enabled;
    }

    public Apple withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public AppleRegistration registration() {
        return this.registration;
    }

    public Apple withRegistration(AppleRegistration registration) {
        this.registration = registration;
        return this;
    }

    public LoginScopes login() {
        return this.login;
    }

    public Apple withLogin(LoginScopes login) {
        this.login = login;
        return this;
    }

    public void validate() {
        if (this.registration() != null) {
            this.registration().validate();
        }
        if (this.login() != null) {
            this.login().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeJsonField("registration", (JsonSerializable)this.registration);
        jsonWriter.writeJsonField("login", (JsonSerializable)this.login);
        return jsonWriter.writeEndObject();
    }

    public static Apple fromJson(JsonReader jsonReader) throws IOException {
        return (Apple)jsonReader.readObject(reader -> {
            Apple deserializedApple = new Apple();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedApple.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("registration".equals(fieldName)) {
                    deserializedApple.registration = AppleRegistration.fromJson(reader);
                    continue;
                }
                if ("login".equals(fieldName)) {
                    deserializedApple.login = LoginScopes.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApple;
        });
    }
}

