/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appservice.fluent.WorkflowTriggersClient;
import com.azure.resourcemanager.appservice.fluent.models.JsonSchemaInner;
import com.azure.resourcemanager.appservice.fluent.models.WorkflowTriggerCallbackUrlInner;
import com.azure.resourcemanager.appservice.fluent.models.WorkflowTriggerInner;
import com.azure.resourcemanager.appservice.implementation.WebSiteManagementClientImpl;
import com.azure.resourcemanager.appservice.models.WorkflowTriggerListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class WorkflowTriggersClientImpl
implements WorkflowTriggersClient {
    private final WorkflowTriggersService service;
    private final WebSiteManagementClientImpl client;

    WorkflowTriggersClientImpl(WebSiteManagementClientImpl client) {
        this.service = (WorkflowTriggersService)RestProxy.create(WorkflowTriggersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WorkflowTriggerInner>> listSinglePageAsync(String resourceGroupName, String name, String workflowName, Integer top, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name, workflowName, "2025-03-01", top, filter, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WorkflowTriggerListResult)res.getValue()).value(), ((WorkflowTriggerListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WorkflowTriggerInner>> listSinglePageAsync(String resourceGroupName, String name, String workflowName, Integer top, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name, workflowName, "2025-03-01", top, filter, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WorkflowTriggerListResult)res.getValue()).value(), ((WorkflowTriggerListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<WorkflowTriggerInner> listAsync(String resourceGroupName, String name, String workflowName, Integer top, String filter) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, name, workflowName, top, filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<WorkflowTriggerInner> listAsync(String resourceGroupName, String name, String workflowName) {
        Integer top = null;
        String filter = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, name, workflowName, top, filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<WorkflowTriggerInner> listAsync(String resourceGroupName, String name, String workflowName, Integer top, String filter, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, name, workflowName, top, filter, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<WorkflowTriggerInner> list(String resourceGroupName, String name, String workflowName) {
        Integer top = null;
        String filter = null;
        return new PagedIterable(this.listAsync(resourceGroupName, name, workflowName, top, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<WorkflowTriggerInner> list(String resourceGroupName, String name, String workflowName, Integer top, String filter, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, name, workflowName, top, filter, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<WorkflowTriggerInner>> getWithResponseAsync(String resourceGroupName, String name, String workflowName, String triggerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (triggerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter triggerName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name, workflowName, triggerName, "2025-03-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<WorkflowTriggerInner>> getWithResponseAsync(String resourceGroupName, String name, String workflowName, String triggerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (triggerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter triggerName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name, workflowName, triggerName, "2025-03-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<WorkflowTriggerInner> getAsync(String resourceGroupName, String name, String workflowName, String triggerName) {
        return this.getWithResponseAsync(resourceGroupName, name, workflowName, triggerName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((WorkflowTriggerInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<WorkflowTriggerInner> getWithResponse(String resourceGroupName, String name, String workflowName, String triggerName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, name, workflowName, triggerName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkflowTriggerInner get(String resourceGroupName, String name, String workflowName, String triggerName) {
        return (WorkflowTriggerInner)((Object)this.getWithResponse(resourceGroupName, name, workflowName, triggerName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<WorkflowTriggerCallbackUrlInner>> listCallbackUrlWithResponseAsync(String resourceGroupName, String name, String workflowName, String triggerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (triggerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter triggerName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listCallbackUrl(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name, workflowName, triggerName, "2025-03-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<WorkflowTriggerCallbackUrlInner>> listCallbackUrlWithResponseAsync(String resourceGroupName, String name, String workflowName, String triggerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (triggerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter triggerName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listCallbackUrl(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name, workflowName, triggerName, "2025-03-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<WorkflowTriggerCallbackUrlInner> listCallbackUrlAsync(String resourceGroupName, String name, String workflowName, String triggerName) {
        return this.listCallbackUrlWithResponseAsync(resourceGroupName, name, workflowName, triggerName).flatMap(res -> Mono.justOrEmpty((Object)((WorkflowTriggerCallbackUrlInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<WorkflowTriggerCallbackUrlInner> listCallbackUrlWithResponse(String resourceGroupName, String name, String workflowName, String triggerName, Context context) {
        return (Response)this.listCallbackUrlWithResponseAsync(resourceGroupName, name, workflowName, triggerName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WorkflowTriggerCallbackUrlInner listCallbackUrl(String resourceGroupName, String name, String workflowName, String triggerName) {
        return (WorkflowTriggerCallbackUrlInner)this.listCallbackUrlWithResponse(resourceGroupName, name, workflowName, triggerName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> runWithResponseAsync(String resourceGroupName, String name, String workflowName, String triggerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (triggerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter triggerName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.run(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name, workflowName, triggerName, "2025-03-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> runWithResponseAsync(String resourceGroupName, String name, String workflowName, String triggerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (triggerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter triggerName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.run(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name, workflowName, triggerName, "2025-03-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginRunAsync(String resourceGroupName, String name, String workflowName, String triggerName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.runWithResponseAsync(resourceGroupName, name, workflowName, triggerName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginRunAsync(String resourceGroupName, String name, String workflowName, String triggerName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.runWithResponseAsync(resourceGroupName, name, workflowName, triggerName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRun(String resourceGroupName, String name, String workflowName, String triggerName) {
        return this.beginRunAsync(resourceGroupName, name, workflowName, triggerName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRun(String resourceGroupName, String name, String workflowName, String triggerName, Context context) {
        return this.beginRunAsync(resourceGroupName, name, workflowName, triggerName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> runAsync(String resourceGroupName, String name, String workflowName, String triggerName) {
        return this.beginRunAsync(resourceGroupName, name, workflowName, triggerName).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> runAsync(String resourceGroupName, String name, String workflowName, String triggerName, Context context) {
        return this.beginRunAsync(resourceGroupName, name, workflowName, triggerName, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void run(String resourceGroupName, String name, String workflowName, String triggerName) {
        this.runAsync(resourceGroupName, name, workflowName, triggerName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void run(String resourceGroupName, String name, String workflowName, String triggerName, Context context) {
        this.runAsync(resourceGroupName, name, workflowName, triggerName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<JsonSchemaInner>> getSchemaJsonWithResponseAsync(String resourceGroupName, String name, String workflowName, String triggerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (triggerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter triggerName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSchemaJson(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name, workflowName, triggerName, "2025-03-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<JsonSchemaInner>> getSchemaJsonWithResponseAsync(String resourceGroupName, String name, String workflowName, String triggerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (triggerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter triggerName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getSchemaJson(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name, workflowName, triggerName, "2025-03-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<JsonSchemaInner> getSchemaJsonAsync(String resourceGroupName, String name, String workflowName, String triggerName) {
        return this.getSchemaJsonWithResponseAsync(resourceGroupName, name, workflowName, triggerName).flatMap(res -> Mono.justOrEmpty((Object)((JsonSchemaInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<JsonSchemaInner> getSchemaJsonWithResponse(String resourceGroupName, String name, String workflowName, String triggerName, Context context) {
        return (Response)this.getSchemaJsonWithResponseAsync(resourceGroupName, name, workflowName, triggerName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public JsonSchemaInner getSchemaJson(String resourceGroupName, String name, String workflowName, String triggerName) {
        return (JsonSchemaInner)this.getSchemaJsonWithResponse(resourceGroupName, name, workflowName, triggerName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WorkflowTriggerInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WorkflowTriggerListResult)res.getValue()).value(), ((WorkflowTriggerListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WorkflowTriggerInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WorkflowTriggerListResult)res.getValue()).value(), ((WorkflowTriggerListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="WebSiteManagementClientWorkflowTriggers")
    public static interface WorkflowTriggersService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostruntime/runtime/webhooks/workflow/api/management/workflows/{workflowName}/triggers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WorkflowTriggerListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="name") String var4, @PathParam(value="workflowName") String var5, @QueryParam(value="api-version") String var6, @QueryParam(value="$top") Integer var7, @QueryParam(value="$filter") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostruntime/runtime/webhooks/workflow/api/management/workflows/{workflowName}/triggers/{triggerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WorkflowTriggerInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="name") String var4, @PathParam(value="workflowName") String var5, @PathParam(value="triggerName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostruntime/runtime/webhooks/workflow/api/management/workflows/{workflowName}/triggers/{triggerName}/listCallbackUrl")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WorkflowTriggerCallbackUrlInner>> listCallbackUrl(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="name") String var4, @PathParam(value="workflowName") String var5, @PathParam(value="triggerName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostruntime/runtime/webhooks/workflow/api/management/workflows/{workflowName}/triggers/{triggerName}/run")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> run(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="name") String var4, @PathParam(value="workflowName") String var5, @PathParam(value="triggerName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostruntime/runtime/webhooks/workflow/api/management/workflows/{workflowName}/triggers/{triggerName}/schemas/json")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JsonSchemaInner>> getSchemaJson(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="name") String var4, @PathParam(value="workflowName") String var5, @PathParam(value="triggerName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WorkflowTriggerListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

