/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appservice.fluent.WorkflowRunActionRepetitionsRequestHistoriesClient;
import com.azure.resourcemanager.appservice.fluent.models.RequestHistoryInner;
import com.azure.resourcemanager.appservice.implementation.WebSiteManagementClientImpl;
import com.azure.resourcemanager.appservice.models.RequestHistoryListResult;
import reactor.core.publisher.Mono;

public final class WorkflowRunActionRepetitionsRequestHistoriesClientImpl
implements WorkflowRunActionRepetitionsRequestHistoriesClient {
    private final WorkflowRunActionRepetitionsRequestHistoriesService service;
    private final WebSiteManagementClientImpl client;

    WorkflowRunActionRepetitionsRequestHistoriesClientImpl(WebSiteManagementClientImpl client) {
        this.service = (WorkflowRunActionRepetitionsRequestHistoriesService)RestProxy.create(WorkflowRunActionRepetitionsRequestHistoriesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RequestHistoryInner>> listSinglePageAsync(String resourceGroupName, String name, String workflowName, String runName, String actionName, String repetitionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (runName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runName is required and cannot be null."));
        }
        if (actionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionName is required and cannot be null."));
        }
        if (repetitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter repetitionName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name, workflowName, runName, actionName, repetitionName, "2025-03-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RequestHistoryListResult)res.getValue()).value(), ((RequestHistoryListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RequestHistoryInner>> listSinglePageAsync(String resourceGroupName, String name, String workflowName, String runName, String actionName, String repetitionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (runName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runName is required and cannot be null."));
        }
        if (actionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionName is required and cannot be null."));
        }
        if (repetitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter repetitionName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name, workflowName, runName, actionName, repetitionName, "2025-03-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RequestHistoryListResult)res.getValue()).value(), ((RequestHistoryListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RequestHistoryInner> listAsync(String resourceGroupName, String name, String workflowName, String runName, String actionName, String repetitionName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, name, workflowName, runName, actionName, repetitionName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RequestHistoryInner> listAsync(String resourceGroupName, String name, String workflowName, String runName, String actionName, String repetitionName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, name, workflowName, runName, actionName, repetitionName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RequestHistoryInner> list(String resourceGroupName, String name, String workflowName, String runName, String actionName, String repetitionName) {
        return new PagedIterable(this.listAsync(resourceGroupName, name, workflowName, runName, actionName, repetitionName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RequestHistoryInner> list(String resourceGroupName, String name, String workflowName, String runName, String actionName, String repetitionName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, name, workflowName, runName, actionName, repetitionName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RequestHistoryInner>> getWithResponseAsync(String resourceGroupName, String name, String workflowName, String runName, String actionName, String repetitionName, String requestHistoryName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (runName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runName is required and cannot be null."));
        }
        if (actionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionName is required and cannot be null."));
        }
        if (repetitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter repetitionName is required and cannot be null."));
        }
        if (requestHistoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter requestHistoryName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name, workflowName, runName, actionName, repetitionName, requestHistoryName, "2025-03-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RequestHistoryInner>> getWithResponseAsync(String resourceGroupName, String name, String workflowName, String runName, String actionName, String repetitionName, String requestHistoryName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (runName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runName is required and cannot be null."));
        }
        if (actionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionName is required and cannot be null."));
        }
        if (repetitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter repetitionName is required and cannot be null."));
        }
        if (requestHistoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter requestHistoryName is required and cannot be null."));
        }
        String apiVersion = "2025-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name, workflowName, runName, actionName, repetitionName, requestHistoryName, "2025-03-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RequestHistoryInner> getAsync(String resourceGroupName, String name, String workflowName, String runName, String actionName, String repetitionName, String requestHistoryName) {
        return this.getWithResponseAsync(resourceGroupName, name, workflowName, runName, actionName, repetitionName, requestHistoryName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RequestHistoryInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RequestHistoryInner> getWithResponse(String resourceGroupName, String name, String workflowName, String runName, String actionName, String repetitionName, String requestHistoryName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, name, workflowName, runName, actionName, repetitionName, requestHistoryName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RequestHistoryInner get(String resourceGroupName, String name, String workflowName, String runName, String actionName, String repetitionName, String requestHistoryName) {
        return (RequestHistoryInner)((Object)this.getWithResponse(resourceGroupName, name, workflowName, runName, actionName, repetitionName, requestHistoryName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RequestHistoryInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RequestHistoryListResult)res.getValue()).value(), ((RequestHistoryListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RequestHistoryInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RequestHistoryListResult)res.getValue()).value(), ((RequestHistoryListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="WebSiteManagementClientWorkflowRunActionRepetitionsRequestHistories")
    public static interface WorkflowRunActionRepetitionsRequestHistoriesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostruntime/runtime/webhooks/workflow/api/management/workflows/{workflowName}/runs/{runName}/actions/{actionName}/repetitions/{repetitionName}/requestHistories")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RequestHistoryListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="name") String var4, @PathParam(value="workflowName") String var5, @PathParam(value="runName") String var6, @PathParam(value="actionName") String var7, @PathParam(value="repetitionName") String var8, @QueryParam(value="api-version") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostruntime/runtime/webhooks/workflow/api/management/workflows/{workflowName}/runs/{runName}/actions/{actionName}/repetitions/{repetitionName}/requestHistories/{requestHistoryName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RequestHistoryInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="name") String var4, @PathParam(value="workflowName") String var5, @PathParam(value="runName") String var6, @PathParam(value="actionName") String var7, @PathParam(value="repetitionName") String var8, @PathParam(value="requestHistoryName") String var9, @QueryParam(value="api-version") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RequestHistoryListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

