/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.WorkflowTriggerHistoryProperties;
import com.azure.resourcemanager.appservice.models.ContentLink;
import com.azure.resourcemanager.appservice.models.Correlation;
import com.azure.resourcemanager.appservice.models.ResourceReference;
import com.azure.resourcemanager.appservice.models.WorkflowStatus;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class WorkflowTriggerHistoryInner
extends SubResource {
    private WorkflowTriggerHistoryProperties innerProperties;
    private String name;
    private String type;

    private WorkflowTriggerHistoryProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public WorkflowTriggerHistoryInner withId(String id) {
        super.withId(id);
        return this;
    }

    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    public OffsetDateTime endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    public OffsetDateTime scheduledTime() {
        return this.innerProperties() == null ? null : this.innerProperties().scheduledTime();
    }

    public WorkflowStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public String code() {
        return this.innerProperties() == null ? null : this.innerProperties().code();
    }

    public Object error() {
        return this.innerProperties() == null ? null : this.innerProperties().error();
    }

    public String trackingId() {
        return this.innerProperties() == null ? null : this.innerProperties().trackingId();
    }

    public Correlation correlation() {
        return this.innerProperties() == null ? null : this.innerProperties().correlation();
    }

    public WorkflowTriggerHistoryInner withCorrelation(Correlation correlation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowTriggerHistoryProperties();
        }
        this.innerProperties().withCorrelation(correlation);
        return this;
    }

    public ContentLink inputsLink() {
        return this.innerProperties() == null ? null : this.innerProperties().inputsLink();
    }

    public ContentLink outputsLink() {
        return this.innerProperties() == null ? null : this.innerProperties().outputsLink();
    }

    public Boolean fired() {
        return this.innerProperties() == null ? null : this.innerProperties().fired();
    }

    public ResourceReference run() {
        return this.innerProperties() == null ? null : this.innerProperties().run();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static WorkflowTriggerHistoryInner fromJson(JsonReader jsonReader) throws IOException {
        return (WorkflowTriggerHistoryInner)((Object)jsonReader.readObject(reader -> {
            WorkflowTriggerHistoryInner deserializedWorkflowTriggerHistoryInner = new WorkflowTriggerHistoryInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryInner.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryInner.innerProperties = WorkflowTriggerHistoryProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryInner.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkflowTriggerHistoryInner;
        }));
    }
}

