/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.AppServiceEnvironmentInner;
import com.azure.resourcemanager.appservice.fluent.models.ValidatePropertiesInner;
import com.azure.resourcemanager.appservice.models.ValidateResourceTypes;
import java.io.IOException;

public final class ValidateRequestInner
implements JsonSerializable<ValidateRequestInner> {
    private String name;
    private ValidateResourceTypes type;
    private String location;
    private ValidatePropertiesInner innerProperties = new ValidatePropertiesInner();
    private static final ClientLogger LOGGER = new ClientLogger(ValidateRequestInner.class);

    public String name() {
        return this.name;
    }

    public ValidateRequestInner withName(String name) {
        this.name = name;
        return this;
    }

    public ValidateResourceTypes type() {
        return this.type;
    }

    public ValidateRequestInner withType(ValidateResourceTypes type) {
        this.type = type;
        return this;
    }

    public String location() {
        return this.location;
    }

    public ValidateRequestInner withLocation(String location) {
        this.location = location;
        return this;
    }

    private ValidatePropertiesInner innerProperties() {
        return this.innerProperties;
    }

    public String serverFarmId() {
        return this.innerProperties() == null ? null : this.innerProperties().serverFarmId();
    }

    public ValidateRequestInner withServerFarmId(String serverFarmId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withServerFarmId(serverFarmId);
        return this;
    }

    public String skuName() {
        return this.innerProperties() == null ? null : this.innerProperties().skuName();
    }

    public ValidateRequestInner withSkuName(String skuName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withSkuName(skuName);
        return this;
    }

    public Boolean needLinuxWorkers() {
        return this.innerProperties() == null ? null : this.innerProperties().needLinuxWorkers();
    }

    public ValidateRequestInner withNeedLinuxWorkers(Boolean needLinuxWorkers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withNeedLinuxWorkers(needLinuxWorkers);
        return this;
    }

    public Boolean isSpot() {
        return this.innerProperties() == null ? null : this.innerProperties().isSpot();
    }

    public ValidateRequestInner withIsSpot(Boolean isSpot) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withIsSpot(isSpot);
        return this;
    }

    public Integer capacity() {
        return this.innerProperties() == null ? null : this.innerProperties().capacity();
    }

    public ValidateRequestInner withCapacity(Integer capacity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withCapacity(capacity);
        return this;
    }

    public String hostingEnvironment() {
        return this.innerProperties() == null ? null : this.innerProperties().hostingEnvironment();
    }

    public ValidateRequestInner withHostingEnvironment(String hostingEnvironment) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withHostingEnvironment(hostingEnvironment);
        return this;
    }

    public Boolean isXenon() {
        return this.innerProperties() == null ? null : this.innerProperties().isXenon();
    }

    public ValidateRequestInner withIsXenon(Boolean isXenon) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withIsXenon(isXenon);
        return this;
    }

    public String containerRegistryBaseUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().containerRegistryBaseUrl();
    }

    public ValidateRequestInner withContainerRegistryBaseUrl(String containerRegistryBaseUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withContainerRegistryBaseUrl(containerRegistryBaseUrl);
        return this;
    }

    public String containerRegistryUsername() {
        return this.innerProperties() == null ? null : this.innerProperties().containerRegistryUsername();
    }

    public ValidateRequestInner withContainerRegistryUsername(String containerRegistryUsername) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withContainerRegistryUsername(containerRegistryUsername);
        return this;
    }

    public String containerRegistryPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().containerRegistryPassword();
    }

    public ValidateRequestInner withContainerRegistryPassword(String containerRegistryPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withContainerRegistryPassword(containerRegistryPassword);
        return this;
    }

    public String containerImageRepository() {
        return this.innerProperties() == null ? null : this.innerProperties().containerImageRepository();
    }

    public ValidateRequestInner withContainerImageRepository(String containerImageRepository) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withContainerImageRepository(containerImageRepository);
        return this;
    }

    public String containerImageTag() {
        return this.innerProperties() == null ? null : this.innerProperties().containerImageTag();
    }

    public ValidateRequestInner withContainerImageTag(String containerImageTag) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withContainerImageTag(containerImageTag);
        return this;
    }

    public String containerImagePlatform() {
        return this.innerProperties() == null ? null : this.innerProperties().containerImagePlatform();
    }

    public ValidateRequestInner withContainerImagePlatform(String containerImagePlatform) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withContainerImagePlatform(containerImagePlatform);
        return this;
    }

    public AppServiceEnvironmentInner appServiceEnvironment() {
        return this.innerProperties() == null ? null : this.innerProperties().appServiceEnvironment();
    }

    public ValidateRequestInner withAppServiceEnvironment(AppServiceEnvironmentInner appServiceEnvironment) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ValidatePropertiesInner();
        }
        this.innerProperties().withAppServiceEnvironment(appServiceEnvironment);
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ValidateRequestInner"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model ValidateRequestInner"));
        }
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model ValidateRequestInner"));
        }
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model ValidateRequestInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ValidateRequestInner fromJson(JsonReader jsonReader) throws IOException {
        return (ValidateRequestInner)jsonReader.readObject(reader -> {
            ValidateRequestInner deserializedValidateRequestInner = new ValidateRequestInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedValidateRequestInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedValidateRequestInner.type = ValidateResourceTypes.fromString(reader.getString());
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedValidateRequestInner.location = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedValidateRequestInner.innerProperties = ValidatePropertiesInner.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedValidateRequestInner;
        });
    }
}

