/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ComputeModeOptions;
import com.azure.resourcemanager.appservice.models.WorkerSizeOptions;
import java.io.IOException;

public final class StampCapacityInner
implements JsonSerializable<StampCapacityInner> {
    private String name;
    private Long availableCapacity;
    private Long totalCapacity;
    private String unit;
    private ComputeModeOptions computeMode;
    private WorkerSizeOptions workerSize;
    private Integer workerSizeId;
    private Boolean excludeFromCapacityAllocation;
    private Boolean isApplicableForAllComputeModes;
    private String siteMode;
    private Boolean isLinux;

    public String name() {
        return this.name;
    }

    public StampCapacityInner withName(String name) {
        this.name = name;
        return this;
    }

    public Long availableCapacity() {
        return this.availableCapacity;
    }

    public StampCapacityInner withAvailableCapacity(Long availableCapacity) {
        this.availableCapacity = availableCapacity;
        return this;
    }

    public Long totalCapacity() {
        return this.totalCapacity;
    }

    public StampCapacityInner withTotalCapacity(Long totalCapacity) {
        this.totalCapacity = totalCapacity;
        return this;
    }

    public String unit() {
        return this.unit;
    }

    public StampCapacityInner withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public ComputeModeOptions computeMode() {
        return this.computeMode;
    }

    public StampCapacityInner withComputeMode(ComputeModeOptions computeMode) {
        this.computeMode = computeMode;
        return this;
    }

    public WorkerSizeOptions workerSize() {
        return this.workerSize;
    }

    public StampCapacityInner withWorkerSize(WorkerSizeOptions workerSize) {
        this.workerSize = workerSize;
        return this;
    }

    public Integer workerSizeId() {
        return this.workerSizeId;
    }

    public StampCapacityInner withWorkerSizeId(Integer workerSizeId) {
        this.workerSizeId = workerSizeId;
        return this;
    }

    public Boolean excludeFromCapacityAllocation() {
        return this.excludeFromCapacityAllocation;
    }

    public StampCapacityInner withExcludeFromCapacityAllocation(Boolean excludeFromCapacityAllocation) {
        this.excludeFromCapacityAllocation = excludeFromCapacityAllocation;
        return this;
    }

    public Boolean isApplicableForAllComputeModes() {
        return this.isApplicableForAllComputeModes;
    }

    public StampCapacityInner withIsApplicableForAllComputeModes(Boolean isApplicableForAllComputeModes) {
        this.isApplicableForAllComputeModes = isApplicableForAllComputeModes;
        return this;
    }

    public String siteMode() {
        return this.siteMode;
    }

    public StampCapacityInner withSiteMode(String siteMode) {
        this.siteMode = siteMode;
        return this;
    }

    public Boolean isLinux() {
        return this.isLinux;
    }

    public StampCapacityInner withIsLinux(Boolean isLinux) {
        this.isLinux = isLinux;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeNumberField("availableCapacity", (Number)this.availableCapacity);
        jsonWriter.writeNumberField("totalCapacity", (Number)this.totalCapacity);
        jsonWriter.writeStringField("unit", this.unit);
        jsonWriter.writeStringField("computeMode", this.computeMode == null ? null : this.computeMode.toString());
        jsonWriter.writeStringField("workerSize", this.workerSize == null ? null : this.workerSize.toString());
        jsonWriter.writeNumberField("workerSizeId", (Number)this.workerSizeId);
        jsonWriter.writeBooleanField("excludeFromCapacityAllocation", this.excludeFromCapacityAllocation);
        jsonWriter.writeBooleanField("isApplicableForAllComputeModes", this.isApplicableForAllComputeModes);
        jsonWriter.writeStringField("siteMode", this.siteMode);
        jsonWriter.writeBooleanField("isLinux", this.isLinux);
        return jsonWriter.writeEndObject();
    }

    public static StampCapacityInner fromJson(JsonReader jsonReader) throws IOException {
        return (StampCapacityInner)jsonReader.readObject(reader -> {
            StampCapacityInner deserializedStampCapacityInner = new StampCapacityInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedStampCapacityInner.name = reader.getString();
                    continue;
                }
                if ("availableCapacity".equals(fieldName)) {
                    deserializedStampCapacityInner.availableCapacity = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("totalCapacity".equals(fieldName)) {
                    deserializedStampCapacityInner.totalCapacity = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedStampCapacityInner.unit = reader.getString();
                    continue;
                }
                if ("computeMode".equals(fieldName)) {
                    deserializedStampCapacityInner.computeMode = ComputeModeOptions.fromString(reader.getString());
                    continue;
                }
                if ("workerSize".equals(fieldName)) {
                    deserializedStampCapacityInner.workerSize = WorkerSizeOptions.fromString(reader.getString());
                    continue;
                }
                if ("workerSizeId".equals(fieldName)) {
                    deserializedStampCapacityInner.workerSizeId = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("excludeFromCapacityAllocation".equals(fieldName)) {
                    deserializedStampCapacityInner.excludeFromCapacityAllocation = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isApplicableForAllComputeModes".equals(fieldName)) {
                    deserializedStampCapacityInner.isApplicableForAllComputeModes = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("siteMode".equals(fieldName)) {
                    deserializedStampCapacityInner.siteMode = reader.getString();
                    continue;
                }
                if ("isLinux".equals(fieldName)) {
                    deserializedStampCapacityInner.isLinux = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStampCapacityInner;
        });
    }
}

