/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ServerFarmInstance;
import java.io.IOException;
import java.util.List;

public final class ServerFarmInstanceDetailsInner
implements JsonSerializable<ServerFarmInstanceDetailsInner> {
    private String serverFarmName;
    private List<ServerFarmInstance> instances;
    private Integer instanceCount;

    public String serverFarmName() {
        return this.serverFarmName;
    }

    public ServerFarmInstanceDetailsInner withServerFarmName(String serverFarmName) {
        this.serverFarmName = serverFarmName;
        return this;
    }

    public List<ServerFarmInstance> instances() {
        return this.instances;
    }

    public ServerFarmInstanceDetailsInner withInstances(List<ServerFarmInstance> instances) {
        this.instances = instances;
        return this;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public ServerFarmInstanceDetailsInner withInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
        return this;
    }

    public void validate() {
        if (this.instances() != null) {
            this.instances().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serverFarmName", this.serverFarmName);
        jsonWriter.writeArrayField("instances", this.instances, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("instanceCount", (Number)this.instanceCount);
        return jsonWriter.writeEndObject();
    }

    public static ServerFarmInstanceDetailsInner fromJson(JsonReader jsonReader) throws IOException {
        return (ServerFarmInstanceDetailsInner)jsonReader.readObject(reader -> {
            ServerFarmInstanceDetailsInner deserializedServerFarmInstanceDetailsInner = new ServerFarmInstanceDetailsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serverFarmName".equals(fieldName)) {
                    deserializedServerFarmInstanceDetailsInner.serverFarmName = reader.getString();
                    continue;
                }
                if ("instances".equals(fieldName)) {
                    List instances;
                    deserializedServerFarmInstanceDetailsInner.instances = instances = reader.readArray(reader1 -> ServerFarmInstance.fromJson(reader1));
                    continue;
                }
                if ("instanceCount".equals(fieldName)) {
                    deserializedServerFarmInstanceDetailsInner.instanceCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerFarmInstanceDetailsInner;
        });
    }
}

