/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ConfigReferenceSource;
import com.azure.resourcemanager.appservice.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appservice.models.ResolveStatus;
import java.io.IOException;

public final class ApiKVReferenceProperties
implements JsonSerializable<ApiKVReferenceProperties> {
    private String reference;
    private ResolveStatus status;
    private String vaultName;
    private String secretName;
    private String secretVersion;
    private ManagedServiceIdentity identityType;
    private String details;
    private ConfigReferenceSource source;
    private String activeVersion;

    public String reference() {
        return this.reference;
    }

    public ApiKVReferenceProperties withReference(String reference) {
        this.reference = reference;
        return this;
    }

    public ResolveStatus status() {
        return this.status;
    }

    public ApiKVReferenceProperties withStatus(ResolveStatus status) {
        this.status = status;
        return this;
    }

    public String vaultName() {
        return this.vaultName;
    }

    public ApiKVReferenceProperties withVaultName(String vaultName) {
        this.vaultName = vaultName;
        return this;
    }

    public String secretName() {
        return this.secretName;
    }

    public ApiKVReferenceProperties withSecretName(String secretName) {
        this.secretName = secretName;
        return this;
    }

    public String secretVersion() {
        return this.secretVersion;
    }

    public ApiKVReferenceProperties withSecretVersion(String secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

    public ManagedServiceIdentity identityType() {
        return this.identityType;
    }

    public ApiKVReferenceProperties withIdentityType(ManagedServiceIdentity identityType) {
        this.identityType = identityType;
        return this;
    }

    public String details() {
        return this.details;
    }

    public ApiKVReferenceProperties withDetails(String details) {
        this.details = details;
        return this;
    }

    public ConfigReferenceSource source() {
        return this.source;
    }

    public ApiKVReferenceProperties withSource(ConfigReferenceSource source) {
        this.source = source;
        return this;
    }

    public String activeVersion() {
        return this.activeVersion;
    }

    public ApiKVReferenceProperties withActiveVersion(String activeVersion) {
        this.activeVersion = activeVersion;
        return this;
    }

    public void validate() {
        if (this.identityType() != null) {
            this.identityType().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reference", this.reference);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("vaultName", this.vaultName);
        jsonWriter.writeStringField("secretName", this.secretName);
        jsonWriter.writeStringField("secretVersion", this.secretVersion);
        jsonWriter.writeJsonField("identityType", (JsonSerializable)this.identityType);
        jsonWriter.writeStringField("details", this.details);
        jsonWriter.writeStringField("source", this.source == null ? null : this.source.toString());
        jsonWriter.writeStringField("activeVersion", this.activeVersion);
        return jsonWriter.writeEndObject();
    }

    public static ApiKVReferenceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ApiKVReferenceProperties)jsonReader.readObject(reader -> {
            ApiKVReferenceProperties deserializedApiKVReferenceProperties = new ApiKVReferenceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("reference".equals(fieldName)) {
                    deserializedApiKVReferenceProperties.reference = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedApiKVReferenceProperties.status = ResolveStatus.fromString(reader.getString());
                    continue;
                }
                if ("vaultName".equals(fieldName)) {
                    deserializedApiKVReferenceProperties.vaultName = reader.getString();
                    continue;
                }
                if ("secretName".equals(fieldName)) {
                    deserializedApiKVReferenceProperties.secretName = reader.getString();
                    continue;
                }
                if ("secretVersion".equals(fieldName)) {
                    deserializedApiKVReferenceProperties.secretVersion = reader.getString();
                    continue;
                }
                if ("identityType".equals(fieldName)) {
                    deserializedApiKVReferenceProperties.identityType = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("details".equals(fieldName)) {
                    deserializedApiKVReferenceProperties.details = reader.getString();
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedApiKVReferenceProperties.source = ConfigReferenceSource.fromString(reader.getString());
                    continue;
                }
                if ("activeVersion".equals(fieldName)) {
                    deserializedApiKVReferenceProperties.activeVersion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiKVReferenceProperties;
        });
    }
}

