/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.VirtualIpMapping;
import java.io.IOException;
import java.util.List;

public final class AddressResponseProperties
implements JsonSerializable<AddressResponseProperties> {
    private String serviceIpAddress;
    private String internalIpAddress;
    private List<String> outboundIpAddresses;
    private List<VirtualIpMapping> vipMappings;

    public String serviceIpAddress() {
        return this.serviceIpAddress;
    }

    public AddressResponseProperties withServiceIpAddress(String serviceIpAddress) {
        this.serviceIpAddress = serviceIpAddress;
        return this;
    }

    public String internalIpAddress() {
        return this.internalIpAddress;
    }

    public AddressResponseProperties withInternalIpAddress(String internalIpAddress) {
        this.internalIpAddress = internalIpAddress;
        return this;
    }

    public List<String> outboundIpAddresses() {
        return this.outboundIpAddresses;
    }

    public AddressResponseProperties withOutboundIpAddresses(List<String> outboundIpAddresses) {
        this.outboundIpAddresses = outboundIpAddresses;
        return this;
    }

    public List<VirtualIpMapping> vipMappings() {
        return this.vipMappings;
    }

    public AddressResponseProperties withVipMappings(List<VirtualIpMapping> vipMappings) {
        this.vipMappings = vipMappings;
        return this;
    }

    public void validate() {
        if (this.vipMappings() != null) {
            this.vipMappings().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceIpAddress", this.serviceIpAddress);
        jsonWriter.writeStringField("internalIpAddress", this.internalIpAddress);
        jsonWriter.writeArrayField("outboundIpAddresses", this.outboundIpAddresses, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("vipMappings", this.vipMappings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AddressResponseProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AddressResponseProperties)jsonReader.readObject(reader -> {
            AddressResponseProperties deserializedAddressResponseProperties = new AddressResponseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serviceIpAddress".equals(fieldName)) {
                    deserializedAddressResponseProperties.serviceIpAddress = reader.getString();
                    continue;
                }
                if ("internalIpAddress".equals(fieldName)) {
                    deserializedAddressResponseProperties.internalIpAddress = reader.getString();
                    continue;
                }
                if ("outboundIpAddresses".equals(fieldName)) {
                    List outboundIpAddresses;
                    deserializedAddressResponseProperties.outboundIpAddresses = outboundIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("vipMappings".equals(fieldName)) {
                    List vipMappings;
                    deserializedAddressResponseProperties.vipMappings = vipMappings = reader.readArray(reader1 -> VirtualIpMapping.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAddressResponseProperties;
        });
    }
}

