/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.DomainPatchResourceProperties;
import com.azure.resourcemanager.appservice.models.Contact;
import com.azure.resourcemanager.appservice.models.DnsType;
import com.azure.resourcemanager.appservice.models.DomainPurchaseConsent;
import com.azure.resourcemanager.appservice.models.DomainStatus;
import com.azure.resourcemanager.appservice.models.Hostname;
import com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.ResourceNotRenewableReason;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class DomainPatchResource
extends ProxyOnlyResource {
    private DomainPatchResourceProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private DomainPatchResourceProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public DomainPatchResource withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public Contact contactAdmin() {
        return this.innerProperties() == null ? null : this.innerProperties().contactAdmin();
    }

    public DomainPatchResource withContactAdmin(Contact contactAdmin) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainPatchResourceProperties();
        }
        this.innerProperties().withContactAdmin(contactAdmin);
        return this;
    }

    public Contact contactBilling() {
        return this.innerProperties() == null ? null : this.innerProperties().contactBilling();
    }

    public DomainPatchResource withContactBilling(Contact contactBilling) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainPatchResourceProperties();
        }
        this.innerProperties().withContactBilling(contactBilling);
        return this;
    }

    public Contact contactRegistrant() {
        return this.innerProperties() == null ? null : this.innerProperties().contactRegistrant();
    }

    public DomainPatchResource withContactRegistrant(Contact contactRegistrant) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainPatchResourceProperties();
        }
        this.innerProperties().withContactRegistrant(contactRegistrant);
        return this;
    }

    public Contact contactTech() {
        return this.innerProperties() == null ? null : this.innerProperties().contactTech();
    }

    public DomainPatchResource withContactTech(Contact contactTech) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainPatchResourceProperties();
        }
        this.innerProperties().withContactTech(contactTech);
        return this;
    }

    public DomainStatus registrationStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().registrationStatus();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<String> nameServers() {
        return this.innerProperties() == null ? null : this.innerProperties().nameServers();
    }

    public Boolean privacy() {
        return this.innerProperties() == null ? null : this.innerProperties().privacy();
    }

    public DomainPatchResource withPrivacy(Boolean privacy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainPatchResourceProperties();
        }
        this.innerProperties().withPrivacy(privacy);
        return this;
    }

    public OffsetDateTime createdTime() {
        return this.innerProperties() == null ? null : this.innerProperties().createdTime();
    }

    public OffsetDateTime expirationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().expirationTime();
    }

    public OffsetDateTime lastRenewedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastRenewedTime();
    }

    public Boolean autoRenew() {
        return this.innerProperties() == null ? null : this.innerProperties().autoRenew();
    }

    public DomainPatchResource withAutoRenew(Boolean autoRenew) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainPatchResourceProperties();
        }
        this.innerProperties().withAutoRenew(autoRenew);
        return this;
    }

    public Boolean readyForDnsRecordManagement() {
        return this.innerProperties() == null ? null : this.innerProperties().readyForDnsRecordManagement();
    }

    public List<Hostname> managedHostNames() {
        return this.innerProperties() == null ? null : this.innerProperties().managedHostNames();
    }

    public DomainPurchaseConsent consent() {
        return this.innerProperties() == null ? null : this.innerProperties().consent();
    }

    public DomainPatchResource withConsent(DomainPurchaseConsent consent) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainPatchResourceProperties();
        }
        this.innerProperties().withConsent(consent);
        return this;
    }

    public List<ResourceNotRenewableReason> domainNotRenewableReasons() {
        return this.innerProperties() == null ? null : this.innerProperties().domainNotRenewableReasons();
    }

    public DnsType dnsType() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsType();
    }

    public DomainPatchResource withDnsType(DnsType dnsType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainPatchResourceProperties();
        }
        this.innerProperties().withDnsType(dnsType);
        return this;
    }

    public String dnsZoneId() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsZoneId();
    }

    public DomainPatchResource withDnsZoneId(String dnsZoneId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainPatchResourceProperties();
        }
        this.innerProperties().withDnsZoneId(dnsZoneId);
        return this;
    }

    public DnsType targetDnsType() {
        return this.innerProperties() == null ? null : this.innerProperties().targetDnsType();
    }

    public DomainPatchResource withTargetDnsType(DnsType targetDnsType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainPatchResourceProperties();
        }
        this.innerProperties().withTargetDnsType(targetDnsType);
        return this;
    }

    public String authCode() {
        return this.innerProperties() == null ? null : this.innerProperties().authCode();
    }

    public DomainPatchResource withAuthCode(String authCode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainPatchResourceProperties();
        }
        this.innerProperties().withAuthCode(authCode);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DomainPatchResource fromJson(JsonReader jsonReader) throws IOException {
        return (DomainPatchResource)((Object)jsonReader.readObject(reader -> {
            DomainPatchResource deserializedDomainPatchResource = new DomainPatchResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDomainPatchResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDomainPatchResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDomainPatchResource.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedDomainPatchResource.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDomainPatchResource.innerProperties = DomainPatchResourceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDomainPatchResource;
        }));
    }
}

